/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.server.QueryProgressStats;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public class QueryStateInfo {
    private final QueryState queryState;
    private final QueryId queryId;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final String query;
    private final DateTime createTime;
    private final String user;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<List<ResourceGroupInfo>> resourceGroupChain;
    private final Optional<QueryProgressStats> progress;

    @JsonCreator
    private QueryStateInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="queryState") QueryState queryState, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="query") String query, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="user") String user, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="resourceGroupChainInfo") Optional<List<ResourceGroupInfo>> resourceGroupChain, @JsonProperty(value="progress") Optional<QueryProgressStats> progress) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.queryState = Objects.requireNonNull(queryState, "queryState is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.query = Objects.requireNonNull(query, "query text is null");
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.user = Objects.requireNonNull(user, "user is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(resourceGroupChain, "resourceGroupChain is null");
        this.resourceGroupChain = resourceGroupChain.map(ImmutableList::copyOf);
        this.progress = Objects.requireNonNull(progress, "progress is null");
    }

    public static QueryStateInfo createQueryStateInfo(QueryInfo queryInfo, Optional<ResourceGroupId> resourceGroupId, Optional<ResourceGroupInfo> rootResourceGroupInfo) {
        Optional<List<ResourceGroupInfo>> resourceGroups = Optional.empty();
        Optional<QueryProgressStats> progress = Optional.empty();
        if (queryInfo.getState() == QueryState.QUEUED) {
            resourceGroups = Optional.of(ImmutableList.of());
            if (resourceGroupId.isPresent() && rootResourceGroupInfo.isPresent()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                ResourceGroupId id = resourceGroupId.get();
                ResourceGroupInfo resourceGroupInfo = rootResourceGroupInfo.get();
                while (true) {
                    builder.add((Object)resourceGroupInfo.createSingleNodeInfo());
                    if (resourceGroupInfo.getSubGroups().isEmpty()) break;
                    Optional subGroupInfo = resourceGroupInfo.getSubGroup(id);
                    Preconditions.checkArgument((boolean)subGroupInfo.isPresent(), (String)"No path from root resource group %s to resource group %s", (Object)rootResourceGroupInfo.get().getId(), (Object)id);
                    resourceGroupInfo = (ResourceGroupInfo)subGroupInfo.get();
                }
                resourceGroups = Optional.of(builder.build().reverse());
            }
        } else if (queryInfo.getState() == QueryState.RUNNING) {
            progress = Optional.of(QueryProgressStats.createQueryProgressStats(queryInfo.getQueryStats()));
        }
        return new QueryStateInfo(queryInfo.getQueryId(), queryInfo.getState(), resourceGroupId, queryInfo.getQuery(), queryInfo.getQueryStats().getCreateTime(), queryInfo.getSession().getUser(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), resourceGroups, progress);
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public QueryState getQueryState() {
        return this.queryState;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public Optional<List<ResourceGroupInfo>> getResourceGroupChain() {
        return this.resourceGroupChain;
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public Optional<QueryProgressStats> getProgress() {
        return this.progress;
    }
}

