/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.DateTimeFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class SequenceFunction {
    private static final Slice MONTH = Slices.utf8Slice((String)"month");

    private SequenceFunction() {
    }

    @Description(value="Sequence function to generate synthetic arrays")
    @ScalarFunction(value="sequence")
    @SqlType(value="array(bigint)")
    public static Block sequence(@SqlType(value="bigint") long start, @SqlType(value="bigint") long stop, @SqlType(value="bigint") long step) {
        return SequenceFunction.fixedWidthSequence(start, stop, step, (FixedWidthType)BigintType.BIGINT);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(bigint)")
    public static Block sequenceDefaultStep(@SqlType(value="bigint") long start, @SqlType(value="bigint") long stop) {
        return SequenceFunction.fixedWidthSequence(start, stop, stop >= start ? 1L : -1L, (FixedWidthType)BigintType.BIGINT);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(timestamp)")
    public static Block sequenceTimestampDayToSecond(@SqlType(value="timestamp") long start, @SqlType(value="timestamp") long stop, @SqlType(value="interval day to second") long step) {
        return SequenceFunction.fixedWidthSequence(start, stop, step, (FixedWidthType)TimestampType.TIMESTAMP);
    }

    @ScalarFunction(value="sequence")
    @SqlType(value="array(timestamp)")
    public static Block sequenceTimestampYearToMonth(ConnectorSession session, @SqlType(value="timestamp") long start, @SqlType(value="timestamp") long end, @SqlType(value="interval year to month") long step) {
        Failures.checkCondition(step != 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "interval must not be zero", new Object[0]);
        Failures.checkCondition(step > 0L ? end >= start : end <= start, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence end value should be greater than or equal to start value if step is greater than zero otherwise end should be less than start", new Object[0]);
        int length = Math.toIntExact(DateTimeFunctions.diffTimestamp(session, MONTH, start, end) / step + 1L);
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus(), length);
        int value = 0;
        for (int i = 0; i < length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, DateTimeOperators.timestampPlusIntervalYearToMonth(session, start, value));
            value = (int)((long)value + step);
        }
        return blockBuilder.build();
    }

    private static Block fixedWidthSequence(long start, long stop, long step, FixedWidthType type) {
        Failures.checkCondition(step != 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "step must not be zero", new Object[0]);
        Failures.checkCondition(step > 0L ? stop >= start : stop < start, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "sequence stop value should be greater than or equal to start value if step is greater than zero otherwise stop should be less than start", new Object[0]);
        int length = Math.toIntExact((stop - start) / step + 1L);
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), length);
        long i = 0L;
        long value = start;
        while (i < (long)length) {
            type.writeLong(blockBuilder, value);
            ++i;
            value += step;
        }
        return blockBuilder.build();
    }
}

