/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.scalar.RowComparisonOperator;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class RowGreaterThanOperator
extends RowComparisonOperator {
    public static final RowGreaterThanOperator ROW_GREATER_THAN = new RowGreaterThanOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowGreaterThanOperator.class, "greater", RowType.class, List.class, Block.class, Block.class);

    private RowGreaterThanOperator() {
        super(OperatorType.GREATER_THAN);
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(type).bindTo(this.getMethodHandles((RowType)type, functionRegistry, OperatorType.GREATER_THAN)), this.isDeterministic());
    }

    public static boolean greater(RowType rowType, List<MethodHandle> lessThanFunctions, Block leftRow, Block rightRow) {
        int compareResult = RowGreaterThanOperator.compare(rowType, lessThanFunctions, leftRow, rightRow);
        return compareResult > 0;
    }
}

