/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MapTransformValueFunction
extends SqlScalarFunction {
    public static final MapTransformValueFunction MAP_TRANSFORM_VALUE_FUNCTION = new MapTransformValueFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapTransformValueFunction.class, "transform", Type.class, Type.class, Type.class, Block.class, MethodHandle.class);

    private MapTransformValueFunction() {
        super(new Signature("transform_values", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V1"), (Object)Signature.typeVariable("V2")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V2)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V1)"), (Object)TypeSignature.parseTypeSignature((String)"function(K,V1,V2)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "apply lambda to each entry of the map and transform the value";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V1");
        Type transformedValueType = boundVariables.getTypeVariable("V2");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(keyType).bindTo(valueType).bindTo(transformedValueType), this.isDeterministic());
    }

    public static Block transform(Type keyType, Type valueType, Type transformedValueType, Block block, MethodHandle function) {
        int positionCount = block.getPositionCount();
        InterleavedBlockBuilder resultBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)transformedValueType), new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; position += 2) {
            Object transformedValue;
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)block, (int)position);
            Object value = TypeUtils.readNativeValue((Type)valueType, (Block)block, (int)(position + 1));
            try {
                transformedValue = function.invoke(key, value);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            keyType.appendTo(block, position, (BlockBuilder)resultBuilder);
            TypeUtils.writeNativeValue((Type)transformedValueType, (BlockBuilder)resultBuilder, (Object)transformedValue);
        }
        return resultBuilder.build();
    }
}

