/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.VariableInstruction;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MapTransformKeyFunction
extends SqlScalarFunction {
    public static final MapTransformKeyFunction MAP_TRANSFORM_KEY_FUNCTION = new MapTransformKeyFunction();

    private MapTransformKeyFunction() {
        super(new Signature("transform_keys", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K1"), (Object)Signature.typeVariable("K2"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K2,V)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K1,V)"), (Object)TypeSignature.parseTypeSignature((String)"function(K1,V,K2)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "apply lambda to each entry of the map and transform the key";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K1");
        Type transformedKeyType = boundVariables.getTypeVariable("K2");
        Type valueType = boundVariables.getTypeVariable("V");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), MapTransformKeyFunction.generateTransformKey(keyType, transformedKeyType, valueType), this.isDeterministic());
    }

    private static MethodHandle generateTransformKey(Type keyType, Type transformedKeyType, Type valueType) {
        BytecodeBlock throwDuplicatedKeyException;
        BytecodeBlock writeKeyElement;
        CallSiteBinder binder = new CallSiteBinder();
        MapType mapType = new MapType(transformedKeyType, valueType);
        Class keyJavaType = Primitives.wrap((Class)keyType.getJavaType());
        Class transformedKeyJavaType = Primitives.wrap((Class)transformedKeyType.getJavaType());
        Class valueJavaType = Primitives.wrap((Class)valueType.getJavaType());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"MapTransformKey"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter function = Parameter.arg((String)"function", MethodHandle.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "transform", ParameterizedType.type(Block.class), (Iterable)ImmutableList.of((Object)session, (Object)block, (Object)function));
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable positionCount = scope.declareVariable(Integer.TYPE, "positionCount");
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        Variable blockBuilder = scope.declareVariable(BlockBuilder.class, "blockBuilder");
        Variable typedSet = scope.declareVariable(TypedSet.class, "typeSet");
        Variable keyElement = scope.declareVariable(keyJavaType, "keyElement");
        Variable transformedKeyElement = scope.declareVariable(transformedKeyJavaType, "transformedKeyElement");
        Variable valueElement = scope.declareVariable(valueJavaType, "valueElement");
        body.append((BytecodeNode)positionCount.set(block.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0])));
        body.append((BytecodeNode)blockBuilder.set(BytecodeExpressions.newInstance(InterleavedBlockBuilder.class, (BytecodeExpression[])new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, (Type)mapType).invoke("getTypeParameters", List.class, new BytecodeExpression[0]), BytecodeExpressions.newInstance(BlockBuilderStatus.class, (BytecodeExpression[])new BytecodeExpression[0]), positionCount})));
        body.append((BytecodeNode)typedSet.set(BytecodeExpressions.newInstance(TypedSet.class, (BytecodeExpression[])new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, transformedKeyType), BytecodeExpressions.divide((BytecodeExpression)positionCount, (BytecodeExpression)BytecodeExpressions.constantInt((int)2))})));
        BytecodeBlock throwNullKeyException = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(PrestoException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((Class)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.getDeclaringClass(), (String)"INVALID_FUNCTION_ARGUMENT").cast(ErrorCodeSupplier.class), BytecodeExpressions.constantString((String)"map key cannot be null")})).throwObject();
        SqlTypeBytecodeExpression keySqlType = SqlTypeBytecodeExpression.constantType(binder, keyType);
        BytecodeBlock loadKeyElement = !keyType.equals((Object)UnknownType.UNKNOWN) ? new BytecodeBlock().append((BytecodeNode)keyElement.set(keySqlType.getValue((BytecodeExpression)block, (BytecodeExpression)position).cast(keyJavaType))) : new BytecodeBlock().append((BytecodeNode)keyElement.set(BytecodeExpressions.constantNull((Class)keyJavaType))).append((BytecodeNode)throwNullKeyException);
        SqlTypeBytecodeExpression valueSqlType = SqlTypeBytecodeExpression.constantType(binder, valueType);
        Object loadValueElement = !valueType.equals((Object)UnknownType.UNKNOWN) ? new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))})).ifTrue((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType))).ifFalse((BytecodeNode)valueElement.set(valueSqlType.getValue((BytecodeExpression)block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1))).cast(valueJavaType))) : new BytecodeBlock().append((BytecodeNode)valueElement.set(BytecodeExpressions.constantNull((Class)valueJavaType)));
        SqlTypeBytecodeExpression transformedKeySqlType = SqlTypeBytecodeExpression.constantType(binder, transformedKeyType);
        if (!transformedKeyType.equals((Object)UnknownType.UNKNOWN)) {
            writeKeyElement = new BytecodeBlock().append((BytecodeNode)transformedKeyElement.set(function.invoke("invokeExact", transformedKeyJavaType, new BytecodeExpression[]{keyElement, valueElement}))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)transformedKeyElement, (BytecodeExpression)BytecodeExpressions.constantNull((Class)transformedKeyJavaType))).ifTrue((BytecodeNode)throwNullKeyException).ifFalse((BytecodeNode)new BytecodeBlock().append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, transformedKeyType).writeValue((BytecodeExpression)blockBuilder, transformedKeyElement.cast(transformedKeyType.getJavaType()))).append((BytecodeNode)valueSqlType.invoke("appendTo", Void.TYPE, new BytecodeExpression[]{block, BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)BytecodeExpressions.constantInt((int)1)), blockBuilder}))));
            throwDuplicatedKeyException = new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(PrestoException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.getStatic((Class)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.getDeclaringClass(), (String)"INVALID_FUNCTION_ARGUMENT").cast(ErrorCodeSupplier.class), BytecodeExpressions.invokeStatic(String.class, (String)"format", String.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"Duplicate keys (%s) are not allowed"), BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Object[].class), (Iterable)ImmutableList.of((Object)transformedKeySqlType.invoke("getObjectValue", Object.class, new BytecodeExpression[]{session, blockBuilder.cast(Block.class), position})))})})).throwObject();
        } else {
            writeKeyElement = throwNullKeyException;
            throwDuplicatedKeyException = throwNullKeyException;
        }
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)VariableInstruction.incrementVariable((Variable)position, (byte)2)).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)loadKeyElement).append((BytecodeNode)loadValueElement).append((BytecodeNode)writeKeyElement).append((BytecodeNode)new IfStatement().condition((BytecodeNode)typedSet.invoke("contains", Boolean.TYPE, new BytecodeExpression[]{blockBuilder.cast(Block.class), position})).ifTrue((BytecodeNode)throwDuplicatedKeyException).ifFalse((BytecodeNode)typedSet.invoke("add", Void.TYPE, new BytecodeExpression[]{blockBuilder.cast(Block.class), position})))));
        body.append((BytecodeNode)blockBuilder.invoke("build", Block.class, new BytecodeExpression[0]).ret());
        Class generatedClass = CompilerUtils.defineClass((ClassDefinition)definition, Object.class, binder.getBindings(), (ClassLoader)MapTransformKeyFunction.class.getClassLoader());
        return Reflection.methodHandle(generatedClass, "transform", ConnectorSession.class, Block.class, MethodHandle.class);
    }
}

