/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.BooleanOperators;
import com.facebook.presto.type.DoubleOperators;
import com.facebook.presto.type.VarcharOperators;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;

public final class JsonOperators {
    public static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonOperators() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            Slice result;
            JsonToken nextToken = parser.nextToken();
            switch (nextToken) {
                case VALUE_NULL: {
                    result = null;
                    break;
                }
                case VALUE_STRING: {
                    result = Slices.utf8Slice((String)parser.getText());
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = DoubleOperators.castToVarchar(parser.getDoubleValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = Slices.utf8Slice((String)parser.getText());
                    break;
                }
                case VALUE_TRUE: {
                    result = BooleanOperators.castToVarchar(true);
                    break;
                }
                case VALUE_FALSE: {
                    result = BooleanOperators.castToVarchar(false);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "varchar"));
                }
            }
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to VARCHAR", new Object[0]);
            Slice slice = result;
            return slice;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "varchar"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="bigint")
    public static Long castToBigint(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            Long result;
            parser.nextToken();
            switch (parser.getCurrentToken()) {
                case VALUE_NULL: {
                    result = null;
                    break;
                }
                case VALUE_STRING: {
                    result = VarcharOperators.castToBigint(Slices.utf8Slice((String)parser.getText()));
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = DoubleOperators.castToLong(parser.getDoubleValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = parser.getLongValue();
                    break;
                }
                case VALUE_TRUE: {
                    result = BooleanOperators.castToBigint(true);
                    break;
                }
                case VALUE_FALSE: {
                    result = BooleanOperators.castToBigint(false);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "bigint"));
                }
            }
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to BIGINT", new Object[0]);
            Long l = result;
            return l;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "bigint"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="integer")
    public static Long castToInteger(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            Long result;
            parser.nextToken();
            switch (parser.getCurrentToken()) {
                case VALUE_NULL: {
                    result = null;
                    break;
                }
                case VALUE_STRING: {
                    result = VarcharOperators.castToInteger(Slices.utf8Slice((String)parser.getText()));
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = DoubleOperators.castToInteger(parser.getDoubleValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = Math.toIntExact(parser.getLongValue());
                    break;
                }
                case VALUE_TRUE: {
                    result = BooleanOperators.castToInteger(true);
                    break;
                }
                case VALUE_FALSE: {
                    result = BooleanOperators.castToInteger(false);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"));
                }
            }
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to INTEGER", new Object[0]);
            Long l = result;
            return l;
        }
        catch (IOException | ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="double")
    public static Double castToDouble(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            Double result;
            parser.nextToken();
            switch (parser.getCurrentToken()) {
                case VALUE_NULL: {
                    result = null;
                    break;
                }
                case VALUE_STRING: {
                    result = VarcharOperators.castToDouble(Slices.utf8Slice((String)parser.getText()));
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = parser.getDoubleValue();
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = parser.getDoubleValue();
                    break;
                }
                case VALUE_TRUE: {
                    result = BooleanOperators.castToDouble(true);
                    break;
                }
                case VALUE_FALSE: {
                    result = BooleanOperators.castToDouble(false);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "double"));
                }
            }
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DOUBLE", new Object[0]);
            Double d = result;
            return d;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "double"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="boolean")
    public static Boolean castToBoolean(@SqlType(value="json") Slice json) {
        try (JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);){
            Boolean result;
            parser.nextToken();
            switch (parser.getCurrentToken()) {
                case VALUE_NULL: {
                    result = null;
                    break;
                }
                case VALUE_STRING: {
                    result = VarcharOperators.castToBoolean(Slices.utf8Slice((String)parser.getText()));
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    result = DoubleOperators.castToBoolean(parser.getDoubleValue());
                    break;
                }
                case VALUE_NUMBER_INT: {
                    result = BigintOperators.castToBoolean(parser.getLongValue());
                    break;
                }
                case VALUE_TRUE: {
                    result = true;
                    break;
                }
                case VALUE_FALSE: {
                    result = false;
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "boolean"));
                }
            }
            Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to BOOLEAN", new Object[0]);
            Boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "boolean"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice castFromVarchar(@SqlType(value="varchar(x)") Slice value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(value.length() + 2);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(value.toStringUtf8());
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value.toStringUtf8(), "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromInteger(@SqlType(value="integer") long value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(20);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromBigint(@SqlType(value="bigint") long value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(20);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromDouble(@SqlType(value="double") double value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromBoolean(@SqlType(value="boolean") boolean value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(5);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeBoolean(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromTimestamp(ConnectorSession session, @SqlType(value="timestamp") long value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(25);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(DateTimeUtils.printTimestampWithoutTimeZone(session.getTimeZoneKey(), value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromDate(ConnectorSession session, @SqlType(value="date") long value) throws IOException {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(12);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(DateTimeUtils.printDate((int)value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="json") Slice value) {
        return value.hashCode();
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equals(@SqlType(value="json") Slice leftJson, @SqlType(value="json") Slice rightJson) {
        return leftJson.equals((Object)rightJson);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="json") Slice leftJson, @SqlType(value="json") Slice rightJson) {
        return !leftJson.equals((Object)rightJson);
    }
}

