/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@Description(value="return array containing elements that match the given predicate")
@ScalarFunction(value="filter", deterministic=false)
public final class ArrayFilterFunction {
    private ArrayFilterFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public static Block filterLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") MethodHandle function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Long input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getLong(arrayBlock, position);
            }
            try {
                keep = function.invokeExact(input);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public static Block filterDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") MethodHandle function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Double input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getDouble(arrayBlock, position);
            }
            try {
                keep = function.invokeExact(input);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public static Block filterBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") MethodHandle function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Boolean input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getBoolean(arrayBlock, position);
            }
            try {
                keep = function.invokeExact(input);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="array(T)")
    public static Block filterSlice(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") MethodHandle function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Slice input = null;
            if (!arrayBlock.isNull(position)) {
                input = elementType.getSlice(arrayBlock, position);
            }
            try {
                keep = function.invokeExact(input);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="array(T)")
    public static Block filterBlock(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") MethodHandle function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            Block input = null;
            if (!arrayBlock.isNull(position)) {
                input = (Block)elementType.getObject(arrayBlock, position);
            }
            try {
                keep = function.invokeExact(input);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            elementType.appendTo(arrayBlock, position, resultBuilder);
        }
        return resultBuilder.build();
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=void.class)
    @SqlType(value="array(T)")
    public static Block filterVoid(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") MethodHandle function) {
        int positionCount = arrayBlock.getPositionCount();
        BlockBuilder resultBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; ++position) {
            Boolean keep;
            try {
                keep = function.invokeExact(null);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            resultBuilder.appendNull();
        }
        return resultBuilder.build();
    }
}

