/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.TypedHeap;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.MinMaxNState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;

public class MinMaxNStateFactory
implements AccumulatorStateFactory<MinMaxNState> {
    public MinMaxNState createSingleState() {
        return new SingleMinMaxNState();
    }

    public Class<? extends MinMaxNState> getSingleStateClass() {
        return SingleMinMaxNState.class;
    }

    public MinMaxNState createGroupedState() {
        return new GroupedMinMaxNState();
    }

    public Class<? extends MinMaxNState> getGroupedStateClass() {
        return GroupedMinMaxNState.class;
    }

    public static class SingleMinMaxNState
    implements MinMaxNState {
        private TypedHeap typedHeap;

        public long getEstimatedSize() {
            if (this.typedHeap == null) {
                return 0L;
            }
            return this.typedHeap.getEstimatedSize();
        }

        @Override
        public TypedHeap getTypedHeap() {
            return this.typedHeap;
        }

        @Override
        public void setTypedHeap(TypedHeap typedHeap) {
            this.typedHeap = typedHeap;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedMinMaxNState
    extends AbstractGroupedAccumulatorState
    implements MinMaxNState {
        private final ObjectBigArray<TypedHeap> heaps = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.heaps.sizeOf() + this.size;
        }

        @Override
        public TypedHeap getTypedHeap() {
            return (TypedHeap)this.heaps.get(this.getGroupId());
        }

        @Override
        public void setTypedHeap(TypedHeap value) {
            TypedHeap previous = this.getTypedHeap();
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.heaps.set(this.getGroupId(), (Object)value);
            this.size += value.getEstimatedSize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }
    }
}

