/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.slice.Slice;
import java.util.Objects;

public class LongDecimalWithOverflowStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowState> {
    public LongDecimalWithOverflowState createSingleState() {
        return new SingleLongDecimalWithOverflowState();
    }

    public Class<? extends LongDecimalWithOverflowState> getSingleStateClass() {
        return SingleLongDecimalWithOverflowState.class;
    }

    public LongDecimalWithOverflowState createGroupedState() {
        return new GroupedLongDecimalWithOverflowState();
    }

    public Class<? extends LongDecimalWithOverflowState> getGroupedStateClass() {
        return GroupedLongDecimalWithOverflowState.class;
    }

    public static class SingleLongDecimalWithOverflowState
    implements LongDecimalWithOverflowState {
        public static final int SIZE = 24;
        protected Slice unscaledDecimal;
        protected long overflow;

        @Override
        public Slice getLongDecimal() {
            return this.unscaledDecimal;
        }

        @Override
        public void setLongDecimal(Slice unscaledDecimal) {
            this.unscaledDecimal = unscaledDecimal;
        }

        @Override
        public long getOverflow() {
            return this.overflow;
        }

        @Override
        public void setOverflow(long overflow) {
            this.overflow = overflow;
        }

        public long getEstimatedSize() {
            if (this.getLongDecimal() == null) {
                return 8L;
            }
            return 24L;
        }
    }

    public static class GroupedLongDecimalWithOverflowState
    extends AbstractGroupedAccumulatorState
    implements LongDecimalWithOverflowState {
        protected final ObjectBigArray<Slice> unscaledDecimals = new ObjectBigArray();
        protected final LongBigArray overflows = new LongBigArray();
        protected long numberOfElements;

        public void ensureCapacity(long size) {
            this.unscaledDecimals.ensureCapacity(size);
            this.overflows.ensureCapacity(size);
        }

        @Override
        public Slice getLongDecimal() {
            return (Slice)this.unscaledDecimals.get(this.getGroupId());
        }

        @Override
        public void setLongDecimal(Slice value) {
            Objects.requireNonNull(value, "value is null");
            if (this.getLongDecimal() == null) {
                ++this.numberOfElements;
            }
            this.unscaledDecimals.set(this.getGroupId(), (Object)value);
        }

        @Override
        public long getOverflow() {
            return this.overflows.get(this.getGroupId());
        }

        @Override
        public void setOverflow(long overflow) {
            this.overflows.set(this.getGroupId(), overflow);
        }

        public long getEstimatedSize() {
            return this.unscaledDecimals.sizeOf() + this.overflows.sizeOf() + this.numberOfElements * 24L;
        }
    }
}

