/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateFactory;

public class LongDecimalWithOverflowAndLongStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowAndLongState> {
    public LongDecimalWithOverflowAndLongState createSingleState() {
        return new SingleLongDecimalWithOverflowAndLongState();
    }

    public Class<? extends LongDecimalWithOverflowAndLongState> getSingleStateClass() {
        return SingleLongDecimalWithOverflowAndLongState.class;
    }

    public LongDecimalWithOverflowAndLongState createGroupedState() {
        return new GroupedLongDecimalWithOverflowAndLongState();
    }

    public Class<? extends LongDecimalWithOverflowAndLongState> getGroupedStateClass() {
        return GroupedLongDecimalWithOverflowAndLongState.class;
    }

    public static class SingleLongDecimalWithOverflowAndLongState
    extends LongDecimalWithOverflowStateFactory.SingleLongDecimalWithOverflowState
    implements LongDecimalWithOverflowAndLongState {
        public static final int SIZE = 32;
        protected long longValue;

        @Override
        public long getLong() {
            return this.longValue;
        }

        @Override
        public void setLong(long longValue) {
            this.longValue = longValue;
        }

        @Override
        public long getEstimatedSize() {
            if (this.getLongDecimal() == null) {
                return 8L;
            }
            return 32L;
        }
    }

    public static class GroupedLongDecimalWithOverflowAndLongState
    extends LongDecimalWithOverflowStateFactory.GroupedLongDecimalWithOverflowState
    implements LongDecimalWithOverflowAndLongState {
        private final LongBigArray longs = new LongBigArray();

        @Override
        public void ensureCapacity(long size) {
            this.longs.ensureCapacity(size);
            super.ensureCapacity(size);
        }

        @Override
        public long getLong() {
            return this.longs.get(this.getGroupId());
        }

        @Override
        public void setLong(long value) {
            this.longs.set(this.getGroupId(), value);
        }

        @Override
        public long getEstimatedSize() {
            return this.unscaledDecimals.sizeOf() + this.overflows.sizeOf() + this.numberOfElements * 32L;
        }
    }
}

