/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.BlockComparator;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import org.openjdk.jol.info.ClassLayout;

public class TypedHeap {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedHeap.class).instanceSize();
    private static final int COMPACT_THRESHOLD_BYTES = 32768;
    private static final int COMPACT_THRESHOLD_RATIO = 3;
    private final BlockComparator comparator;
    private final Type type;
    private final int capacity;
    private int positionCount;
    private final int[] heapIndex;
    private BlockBuilder heapBlockBuilder;

    public TypedHeap(BlockComparator comparator, Type type, int capacity) {
        this.comparator = comparator;
        this.type = type;
        this.capacity = capacity;
        this.heapIndex = new int[capacity];
        this.heapBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), capacity);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public long getEstimatedSize() {
        return (long)(INSTANCE_SIZE + this.heapBlockBuilder.getRetainedSizeInBytes()) + SizeOf.sizeOf((int[])this.heapIndex);
    }

    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    public void writeAll(BlockBuilder resultBlockBuilder) {
        for (int i = 0; i < this.positionCount; ++i) {
            this.type.appendTo((Block)this.heapBlockBuilder, this.heapIndex[i], resultBlockBuilder);
        }
    }

    public void popAll(BlockBuilder resultBlockBuilder) {
        while (this.positionCount > 0) {
            this.pop(resultBlockBuilder);
        }
    }

    public void pop(BlockBuilder resultBlockBuilder) {
        this.type.appendTo((Block)this.heapBlockBuilder, this.heapIndex[0], resultBlockBuilder);
        this.remove();
    }

    private void remove() {
        --this.positionCount;
        this.heapIndex[0] = this.heapIndex[this.positionCount];
        this.siftDown();
    }

    public void add(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0);
        if (this.positionCount == this.capacity) {
            if (this.comparator.compareTo((Block)this.heapBlockBuilder, this.heapIndex[0], block, position) >= 0) {
                return;
            }
            this.heapIndex[0] = this.heapBlockBuilder.getPositionCount();
            this.type.appendTo(block, position, this.heapBlockBuilder);
            this.siftDown();
        } else {
            this.heapIndex[this.positionCount] = this.heapBlockBuilder.getPositionCount();
            ++this.positionCount;
            this.type.appendTo(block, position, this.heapBlockBuilder);
            this.siftUp();
        }
        this.compactIfNecessary();
    }

    public void addAll(TypedHeap other) {
        for (int i = 0; i < other.positionCount; ++i) {
            this.add((Block)other.heapBlockBuilder, other.heapIndex[i]);
        }
    }

    public void addAll(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            this.add(block, i);
        }
    }

    private void siftDown() {
        int leftPosition;
        int position = 0;
        while ((leftPosition = position * 2 + 1) < this.positionCount) {
            int smallerChildPosition;
            int rightPosition = leftPosition + 1;
            if (rightPosition >= this.positionCount) {
                smallerChildPosition = leftPosition;
            } else {
                int n = smallerChildPosition = this.comparator.compareTo((Block)this.heapBlockBuilder, this.heapIndex[leftPosition], (Block)this.heapBlockBuilder, this.heapIndex[rightPosition]) >= 0 ? rightPosition : leftPosition;
            }
            if (this.comparator.compareTo((Block)this.heapBlockBuilder, this.heapIndex[smallerChildPosition], (Block)this.heapBlockBuilder, this.heapIndex[position]) >= 0) break;
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[smallerChildPosition];
            this.heapIndex[smallerChildPosition] = swapTemp;
            position = smallerChildPosition;
        }
    }

    private void siftUp() {
        int parentPosition;
        int position = this.positionCount - 1;
        while (position != 0 && this.comparator.compareTo((Block)this.heapBlockBuilder, this.heapIndex[position], (Block)this.heapBlockBuilder, this.heapIndex[parentPosition = (position - 1) / 2]) < 0) {
            int swapTemp = this.heapIndex[position];
            this.heapIndex[position] = this.heapIndex[parentPosition];
            this.heapIndex[parentPosition] = swapTemp;
            position = parentPosition;
        }
    }

    private void compactIfNecessary() {
        if (this.heapBlockBuilder.getSizeInBytes() < 32768 || this.heapBlockBuilder.getPositionCount() / this.positionCount < 3) {
            return;
        }
        BlockBuilder newHeapBlockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus(), this.heapBlockBuilder.getPositionCount());
        for (int i = 0; i < this.positionCount; ++i) {
            this.type.appendTo((Block)this.heapBlockBuilder, this.heapIndex[i], newHeapBlockBuilder);
            this.heapIndex[i] = i;
        }
        this.heapBlockBuilder = newHeapBlockBuilder;
    }
}

