/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.MultiKeyValuePairs;
import com.facebook.presto.operator.aggregation.state.MultiKeyValuePairStateSerializer;
import com.facebook.presto.operator.aggregation.state.MultiKeyValuePairsState;
import com.facebook.presto.operator.aggregation.state.MultiKeyValuePairsStateFactory;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class MultimapAggregationFunction
extends SqlAggregationFunction {
    public static final MultimapAggregationFunction MULTIMAP_AGG = new MultimapAggregationFunction();
    public static final String NAME = "multimap_agg";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "output", MultiKeyValuePairsState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "input", MultiKeyValuePairsState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MultimapAggregationFunction.class, "combine", MultiKeyValuePairsState.class, MultiKeyValuePairsState.class);

    public MultimapAggregationFunction() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,array(V))"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"K"), (Object)TypeSignature.parseTypeSignature((String)"V")));
    }

    @Override
    public String getDescription() {
        return "Aggregates all the rows (key/value pairs) into a single multimap";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        return MultimapAggregationFunction.generateAggregation(keyType, valueType);
    }

    private static InternalAggregationFunction generateAggregation(Type keyType, Type valueType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MultimapAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)keyType, (Object)valueType);
        MapType outputType = new MapType(keyType, (Type)new ArrayType(valueType));
        MultiKeyValuePairStateSerializer stateSerializer = new MultiKeyValuePairStateSerializer(keyType, valueType);
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), MultimapAggregationFunction.createInputParameterMetadata(keyType, valueType), INPUT_FUNCTION, COMBINE_FUNCTION, OUTPUT_FUNCTION, MultiKeyValuePairsState.class, stateSerializer, new MultiKeyValuePairsStateFactory(keyType, valueType), (Type)outputType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, (Type)outputType, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type keyType, Type valueType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, keyType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, valueType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(MultiKeyValuePairsState state, Block key, Block value, int position) {
        MultiKeyValuePairs pairs = state.get();
        if (pairs == null) {
            pairs = new MultiKeyValuePairs(state.getKeyType(), state.getValueType());
            state.set(pairs);
        }
        long startSize = pairs.estimatedInMemorySize();
        try {
            pairs.add(key, value, position, position);
        }
        catch (ExceededMemoryLimitException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("The result of map_agg may not exceed %s", e.getMaxMemory()));
        }
        state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
    }

    public static void combine(MultiKeyValuePairsState state, MultiKeyValuePairsState otherState) {
        if (state.get() != null && otherState.get() != null) {
            Block keys = otherState.get().getKeys();
            Block values = otherState.get().getValues();
            MultiKeyValuePairs pairs = state.get();
            long startSize = pairs.estimatedInMemorySize();
            for (int i = 0; i < keys.getPositionCount(); ++i) {
                try {
                    pairs.add(keys, values, i, i);
                    continue;
                }
                catch (ExceededMemoryLimitException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("The result of map_agg may not exceed %s", e.getMaxMemory()));
                }
            }
            state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    public static void output(MultiKeyValuePairsState state, BlockBuilder out) {
        MultiKeyValuePairs pairs = state.get();
        if (pairs == null) {
            out.appendNull();
        } else {
            Block block = pairs.toMultimapNativeEncoding();
            out.writeObject((Object)block);
            out.closeEntry();
        }
    }
}

