/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class KeyValuePairs {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(KeyValuePairs.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private final BlockBuilder keyBlockBuilder;
    private final Type keyType;
    private final BlockBuilder valueBlockBuilder;
    private final Type valueType;
    private int[] keyPositionByHash;
    private int hashCapacity;
    private int maxFill;
    private int hashMask;

    public KeyValuePairs(Type keyType, Type valueType) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.keyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(keyType, 16));
        this.valueBlockBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(valueType, 16));
        this.hashCapacity = HashCommon.arraySize((int)10, (float)0.75f);
        this.maxFill = KeyValuePairs.calculateMaxFill(this.hashCapacity);
        this.hashMask = this.hashCapacity - 1;
        this.keyPositionByHash = new int[this.hashCapacity];
        Arrays.fill(this.keyPositionByHash, -1);
    }

    public KeyValuePairs(Block serialized, Type keyType, Type valueType) {
        this(keyType, valueType);
        this.deserialize(Objects.requireNonNull(serialized, "serialized is null"));
    }

    public Block getKeys() {
        return this.keyBlockBuilder.build();
    }

    public Block getValues() {
        return this.valueBlockBuilder.build();
    }

    private void deserialize(Block block) {
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            this.add(block, block, i, i + 1);
        }
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder mapBlockBuilder = out.beginBlockEntry();
        for (int i = 0; i < this.keyBlockBuilder.getPositionCount(); ++i) {
            this.keyType.appendTo((Block)this.keyBlockBuilder, i, mapBlockBuilder);
            this.valueType.appendTo((Block)this.valueBlockBuilder, i, mapBlockBuilder);
        }
        out.closeEntry();
    }

    public long estimatedInMemorySize() {
        long size = INSTANCE_SIZE;
        size += (long)this.keyBlockBuilder.getRetainedSizeInBytes();
        size += (long)this.valueBlockBuilder.getRetainedSizeInBytes();
        return size += SizeOf.sizeOf((int[])this.keyPositionByHash);
    }

    public void add(Block key, Block value, int keyPosition, int valuePosition) {
        if (!this.keyExists(key, keyPosition)) {
            this.addKey(key, keyPosition);
            if (value.isNull(valuePosition)) {
                this.valueBlockBuilder.appendNull();
            } else {
                this.valueType.appendTo(value, valuePosition, this.valueBlockBuilder);
            }
        }
    }

    private boolean keyExists(Block key, int position) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position is negative");
        return this.keyPositionByHash[this.getHashPositionOfKey(key, position)] != -1;
    }

    private void addKey(Block key, int position) {
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position is negative");
        this.keyType.appendTo(key, position, this.keyBlockBuilder);
        int hashPosition = this.getHashPositionOfKey(key, position);
        if (this.keyPositionByHash[hashPosition] == -1) {
            this.keyPositionByHash[hashPosition] = this.keyBlockBuilder.getPositionCount() - 1;
            if (this.keyBlockBuilder.getPositionCount() >= this.maxFill) {
                this.rehash();
            }
        }
    }

    private int getHashPositionOfKey(Block key, int position) {
        int hashPosition = this.getMaskedHash(TypeUtils.hashPosition(this.keyType, key, position));
        while (this.keyPositionByHash[hashPosition] != -1) {
            if (TypeUtils.positionEqualsPosition(this.keyType, (Block)this.keyBlockBuilder, this.keyPositionByHash[hashPosition], key, position)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
        return hashPosition;
    }

    private void rehash() {
        int newCapacity;
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.hashCapacity = newCapacity = (int)newCapacityLong;
        this.hashMask = newCapacity - 1;
        this.maxFill = KeyValuePairs.calculateMaxFill(newCapacity);
        this.keyPositionByHash = new int[newCapacity];
        Arrays.fill(this.keyPositionByHash, -1);
        for (int position = 0; position < this.keyBlockBuilder.getPositionCount(); ++position) {
            this.keyPositionByHash[this.getHashPositionOfKey((Block)this.keyBlockBuilder, (int)position)] = position;
        }
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private int getMaskedHash(long rawHash) {
        return (int)(rawHash & (long)this.hashMask);
    }
}

