/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TableFinishInfo;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TableFinishOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final TableFinisher tableFinisher;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean closed;
    private Optional<ConnectorOutputMetadata> outputMetadata = Optional.empty();
    private final ImmutableList.Builder<Slice> fragmentBuilder = ImmutableList.builder();

    public TableFinishOperator(OperatorContext operatorContext, TableFinisher tableFinisher) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.tableFinisher = Objects.requireNonNull(tableFinisher, "tableCommitter is null");
        operatorContext.setInfoSupplier(() -> new TableFinishInfo(this.outputMetadata));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object)((Object)this.state));
        Block rowCountBlock = page.getBlock(0);
        Block fragmentBlock = page.getBlock(1);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!rowCountBlock.isNull(position)) {
                this.rowCount += BigintType.BIGINT.getLong(rowCountBlock, position);
            }
            if (fragmentBlock.isNull(position)) continue;
            this.fragmentBuilder.add((Object)VarbinaryType.VARBINARY.getSlice(fragmentBlock, position));
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        this.outputMetadata = this.tableFinisher.finishTable((Collection<Slice>)this.fragmentBuilder.build());
        PageBuilder page = new PageBuilder(this.getTypes());
        page.declarePosition();
        BigintType.BIGINT.writeLong(page.getBlockBuilder(0), this.rowCount);
        return page.build();
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public static interface TableFinisher {
        public Optional<ConnectorOutputMetadata> finishTable(Collection<Slice> var1);
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableFinishOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final TableFinisher tableFinisher;
        private boolean closed;

        public TableFinishOperatorFactory(int operatorId, PlanNodeId planNodeId, TableFinisher tableFinisher) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.tableFinisher = Objects.requireNonNull(tableFinisher, "tableCommitter is null");
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableFinishOperator.class.getSimpleName());
            return new TableFinishOperator(context, this.tableFinisher);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableFinishOperatorFactory(this.operatorId, this.planNodeId, this.tableFinisher);
        }
    }
}

