/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.DateTime;

public class DriverContext {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final PipelineContext pipelineContext;
    private final Executor executor;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final DateTime createdTime = DateTime.now();
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicLong intervalWallStart = new AtomicLong();
    private final AtomicLong intervalCpuStart = new AtomicLong();
    private final AtomicLong intervalUserStart = new AtomicLong();
    private final AtomicLong processCalls = new AtomicLong();
    private final AtomicLong processWallNanos = new AtomicLong();
    private final AtomicLong processCpuNanos = new AtomicLong();
    private final AtomicLong processUserNanos = new AtomicLong();
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicReference<DateTime> executionStartTime = new AtomicReference();
    private final AtomicReference<DateTime> executionEndTime = new AtomicReference();
    private final AtomicLong memoryReservation = new AtomicLong();
    private final AtomicLong peakMemoryReservation = new AtomicLong();
    private final AtomicLong systemMemoryReservation = new AtomicLong();
    private final List<OperatorContext> operatorContexts = new CopyOnWriteArrayList<OperatorContext>();
    private final boolean partitioned;

    public DriverContext(PipelineContext pipelineContext, Executor executor, boolean partitioned) {
        this.pipelineContext = Objects.requireNonNull(pipelineContext, "pipelineContext is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.partitioned = partitioned;
    }

    public TaskId getTaskId() {
        return this.pipelineContext.getTaskId();
    }

    public OperatorContext addOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        for (OperatorContext operatorContext : this.operatorContexts) {
            Preconditions.checkArgument((operatorId != operatorContext.getOperatorId() ? 1 : 0) != 0, (String)"A context already exists for operatorId %s", (int)operatorId);
        }
        OperatorContext operatorContext = new OperatorContext(operatorId, planNodeId, operatorType, this, this.executor);
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public List<OperatorContext> getOperatorContexts() {
        return ImmutableList.copyOf(this.operatorContexts);
    }

    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }

    public Session getSession() {
        return this.pipelineContext.getSession();
    }

    public void startProcessTimer() {
        if (this.startNanos.compareAndSet(0L, System.nanoTime())) {
            this.pipelineContext.start();
            this.executionStartTime.set(DateTime.now());
        }
        this.intervalWallStart.set(System.nanoTime());
        this.intervalCpuStart.set(this.currentThreadCpuTime());
        this.intervalUserStart.set(this.currentThreadUserTime());
    }

    public void recordProcessed() {
        this.processCalls.incrementAndGet();
        this.processWallNanos.getAndAdd(DriverContext.nanosBetween(this.intervalWallStart.get(), System.nanoTime()));
        this.processCpuNanos.getAndAdd(DriverContext.nanosBetween(this.intervalCpuStart.get(), this.currentThreadCpuTime()));
        this.processUserNanos.getAndAdd(DriverContext.nanosBetween(this.intervalUserStart.get(), this.currentThreadUserTime()));
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.executor);
    }

    public void finished() {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.executionEndTime.set(DateTime.now());
        this.endNanos.set(System.nanoTime());
        this.pipelineContext.driverFinished(this);
    }

    public void failed(Throwable cause) {
        this.pipelineContext.failed(cause);
        this.finished.set(true);
    }

    public boolean isDone() {
        return this.finished.get() || this.pipelineContext.isDone();
    }

    public void transferMemoryToTaskContext(long bytes) {
        this.pipelineContext.transferMemoryToTaskContext(bytes);
        Preconditions.checkArgument((this.memoryReservation.addAndGet(-bytes) >= 0L ? 1 : 0) != 0, (Object)"Tried to transfer more memory than is reserved");
    }

    public ListenableFuture<?> reserveMemory(long bytes) {
        ListenableFuture<?> future = this.pipelineContext.reserveMemory(bytes);
        long newMemoryReservation = this.memoryReservation.addAndGet(bytes);
        this.peakMemoryReservation.accumulateAndGet(newMemoryReservation, Math::max);
        return future;
    }

    public ListenableFuture<?> reserveSystemMemory(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        ListenableFuture<?> future = this.pipelineContext.reserveSystemMemory(bytes);
        this.systemMemoryReservation.getAndAdd(bytes);
        return future;
    }

    public ListenableFuture<?> reserveSpill(long bytes) {
        return this.pipelineContext.reserveSpill(bytes);
    }

    public boolean tryReserveMemory(long bytes) {
        if (this.pipelineContext.tryReserveMemory(bytes)) {
            long newMemoryReservation = this.memoryReservation.addAndGet(bytes);
            this.peakMemoryReservation.accumulateAndGet(newMemoryReservation, Math::max);
            return true;
        }
        return false;
    }

    public void freeMemory(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.memoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.pipelineContext.freeMemory(bytes);
        this.memoryReservation.getAndAdd(-bytes);
    }

    public void freeSystemMemory(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((bytes <= this.systemMemoryReservation.get() ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.pipelineContext.freeSystemMemory(bytes);
        this.systemMemoryReservation.getAndAdd(-bytes);
    }

    public void freeSpill(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.pipelineContext.freeSpill(bytes);
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryReservation.get();
    }

    public long getMemoryUsage() {
        return this.memoryReservation.get();
    }

    public void moreMemoryAvailable() {
        this.operatorContexts.forEach(OperatorContext::moreMemoryAvailable);
    }

    public boolean isVerboseStats() {
        return this.pipelineContext.isVerboseStats();
    }

    public boolean isCpuTimerEnabled() {
        return this.pipelineContext.isCpuTimerEnabled();
    }

    public CounterStat getInputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getInputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputPositions();
        }
        return new CounterStat();
    }

    public CounterStat getOutputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getOutputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputPositions();
        }
        return new CounterStat();
    }

    public DriverStats getDriverStats() {
        long outputPositions;
        DataSize outputDataSize;
        long processedInputPositions;
        DataSize processedInputDataSize;
        Duration rawInputReadTime;
        long rawInputPositions;
        DataSize rawInputDataSize;
        ImmutableList operators;
        OperatorStats inputOperator;
        long totalScheduledTime = this.processWallNanos.get();
        long totalCpuTime = this.processCpuNanos.get();
        long totalUserTime = this.processUserNanos.get();
        long totalBlockedTime = this.blockedWallNanos.get();
        BlockedMonitor blockedMonitor = this.blockedMonitor.get();
        if (blockedMonitor != null) {
            totalBlockedTime += blockedMonitor.getBlockedTime();
        }
        if ((inputOperator = (OperatorStats)Iterables.getFirst((Iterable)(operators = ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext::getOperatorStats))), null)) != null) {
            rawInputDataSize = inputOperator.getInputDataSize();
            rawInputPositions = inputOperator.getInputPositions();
            rawInputReadTime = inputOperator.getAddInputWall();
            processedInputDataSize = inputOperator.getOutputDataSize();
            processedInputPositions = inputOperator.getOutputPositions();
            OperatorStats outputOperator = (OperatorStats)Objects.requireNonNull(Iterables.getLast((Iterable)operators, null));
            outputDataSize = outputOperator.getOutputDataSize();
            outputPositions = outputOperator.getOutputPositions();
        } else {
            rawInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            rawInputPositions = 0L;
            rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
            processedInputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            processedInputPositions = 0L;
            outputDataSize = new DataSize(0.0, DataSize.Unit.BYTE);
            outputPositions = 0L;
        }
        long startNanos = this.startNanos.get();
        if (startNanos < this.createNanos) {
            startNanos = System.nanoTime();
        }
        Duration queuedTime = new Duration((double)(startNanos - this.createNanos), TimeUnit.NANOSECONDS);
        long endNanos = this.endNanos.get();
        Duration elapsedTime = endNanos >= startNanos ? new Duration((double)(endNanos - this.createNanos), TimeUnit.NANOSECONDS) : new Duration(0.0, TimeUnit.NANOSECONDS);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (OperatorStats operator : operators) {
            if (!operator.getBlockedReason().isPresent()) continue;
            builder.add((Object)operator.getBlockedReason().get());
        }
        return new DriverStats(this.createdTime, this.executionStartTime.get(), this.executionEndTime.get(), queuedTime.convertToMostSuccinctTimeUnit(), elapsedTime.convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)this.memoryReservation.get()), DataSize.succinctBytes((long)this.peakMemoryReservation.get()), DataSize.succinctBytes((long)this.systemMemoryReservation.get()), new Duration((double)totalScheduledTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalUserTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), blockedMonitor != null, (Set<BlockedReason>)builder.build(), rawInputDataSize.convertToMostSuccinctDataSize(), rawInputPositions, rawInputReadTime, processedInputDataSize.convertToMostSuccinctDataSize(), processedInputPositions, outputDataSize.convertToMostSuccinctDataSize(), outputPositions, (List<OperatorStats>)ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext::getOperatorStats)));
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    private long currentThreadUserTime() {
        if (!this.isCpuTimerEnabled()) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadUserTime();
    }

    private long currentThreadCpuTime() {
        if (!this.isCpuTimerEnabled()) {
            return 0L;
        }
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }

    private static long nanosBetween(long start, long end) {
        return Math.abs(end - start);
    }

    @Deprecated
    public Executor getExecutor() {
        return this.executor;
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BlockedMonitor blockedMonitor = this;
            synchronized (blockedMonitor) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                DriverContext.this.blockedMonitor.compareAndSet(this, null);
                DriverContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
            }
        }

        public long getBlockedTime() {
            return DriverContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

