/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class CatalogMetadata {
    private static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private final ConnectorId connectorId;
    private final ConnectorMetadata metadata;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorId informationSchemaId;
    private final ConnectorMetadata informationSchema;
    private final ConnectorTransactionHandle informationSchemaTransactionHandle;
    private final ConnectorId systemTablesId;
    private final ConnectorMetadata systemTables;
    private final ConnectorTransactionHandle systemTablesTransactionHandle;

    public CatalogMetadata(ConnectorId connectorId, ConnectorMetadata metadata, ConnectorTransactionHandle transactionHandle, ConnectorId informationSchemaId, ConnectorMetadata informationSchema, ConnectorTransactionHandle informationSchemaTransactionHandle, ConnectorId systemTablesId, ConnectorMetadata systemTables, ConnectorTransactionHandle systemTablesTransactionHandle) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.informationSchemaId = Objects.requireNonNull(informationSchemaId, "informationSchemaId is null");
        this.informationSchema = Objects.requireNonNull(informationSchema, "informationSchema is null");
        this.informationSchemaTransactionHandle = Objects.requireNonNull(informationSchemaTransactionHandle, "informationSchemaTransactionHandle is null");
        this.systemTablesId = Objects.requireNonNull(systemTablesId, "systemTablesId is null");
        this.systemTables = Objects.requireNonNull(systemTables, "systemTables is null");
        this.systemTablesTransactionHandle = Objects.requireNonNull(systemTablesTransactionHandle, "systemTablesTransactionHandle is null");
    }

    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    public ConnectorMetadata getMetadata() {
        return this.metadata;
    }

    public ConnectorMetadata getMetadataFor(ConnectorId connectorId) {
        if (connectorId.equals(this.connectorId)) {
            return this.metadata;
        }
        if (connectorId.equals(this.informationSchemaId)) {
            return this.informationSchema;
        }
        if (connectorId.equals(this.systemTablesId)) {
            return this.systemTables;
        }
        throw new IllegalArgumentException("Unknown connector id: " + connectorId);
    }

    public ConnectorTransactionHandle getTransactionHandleFor(ConnectorId connectorId) {
        if (connectorId.equals(this.connectorId)) {
            return this.transactionHandle;
        }
        if (connectorId.equals(this.informationSchemaId)) {
            return this.informationSchemaTransactionHandle;
        }
        if (connectorId.equals(this.systemTablesId)) {
            return this.systemTablesTransactionHandle;
        }
        throw new IllegalArgumentException("Unknown connector id: " + connectorId);
    }

    public ConnectorId getConnectorId(QualifiedObjectName table) {
        if (table.getSchemaName().equals(INFORMATION_SCHEMA_NAME)) {
            return this.informationSchemaId;
        }
        if (this.systemTables.getTableHandle(null, table.asSchemaTableName()) != null) {
            return this.systemTablesId;
        }
        return this.connectorId;
    }

    public List<ConnectorId> listConnectorIds() {
        return ImmutableList.of((Object)this.informationSchemaId, (Object)this.systemTablesId, (Object)this.connectorId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).toString();
    }
}

