/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

final class IndexedPriorityQueue<E>
implements UpdateablePriorityQueue<E> {
    private final Map<E, Entry<E>> index = new HashMap<E, Entry<E>>();
    private final Set<Entry<E>> queue = new TreeSet<Entry<E>>((entry1, entry2) -> {
        int priorityComparison = Integer.compare(entry2.getPriority(), entry1.getPriority());
        if (priorityComparison != 0) {
            return priorityComparison;
        }
        return Long.compare(entry1.getGeneration(), entry2.getGeneration());
    });
    private long generation;

    IndexedPriorityQueue() {
    }

    @Override
    public boolean addOrUpdate(E element, int priority) {
        Entry<E> entry = this.index.get(element);
        if (entry != null) {
            this.queue.remove(entry);
            Entry newEntry = new Entry(element, priority, entry.getGeneration());
            this.queue.add(newEntry);
            this.index.put(element, newEntry);
            return false;
        }
        Entry newEntry = new Entry(element, priority, this.generation);
        ++this.generation;
        this.queue.add(newEntry);
        this.index.put(element, newEntry);
        return true;
    }

    @Override
    public boolean contains(E element) {
        return this.index.containsKey(element);
    }

    @Override
    public boolean remove(E element) {
        Entry<E> entry = this.index.remove(element);
        if (entry != null) {
            this.queue.remove(entry);
            return true;
        }
        return false;
    }

    @Override
    public E poll() {
        Iterator<Entry<E>> iterator = this.queue.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Entry<E> entry = iterator.next();
        iterator.remove();
        Preconditions.checkState((this.index.remove(entry.getValue()) != null ? 1 : 0) != 0, (Object)"Failed to remove entry from index");
        return entry.getValue();
    }

    @Override
    public E peek() {
        Iterator<Entry<E>> iterator = this.queue.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Entry<E> entry = iterator.next();
        return entry.getValue();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private static final class Entry<E> {
        private final E value;
        private final int priority;
        private final long generation;

        private Entry(E value, int priority, long generation) {
            this.value = Objects.requireNonNull(value, "value is null");
            this.priority = priority;
            this.generation = generation;
        }

        public E getValue() {
            return this.value;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getGeneration() {
            return this.generation;
        }
    }
}

