/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class SqlTaskExecution {
    private final TaskId taskId;
    private final TaskStateMachine taskStateMachine;
    private final TaskContext taskContext;
    private final OutputBuffer outputBuffer;
    private final TaskExecutor.TaskHandle taskHandle;
    private final TaskExecutor taskExecutor;
    private final Executor notificationExecutor;
    private final QueryMonitor queryMonitor;
    private final List<WeakReference<Driver>> drivers = new CopyOnWriteArrayList<WeakReference<Driver>>();
    private final AtomicInteger remainingDrivers = new AtomicInteger();
    @GuardedBy(value="this")
    private final ConcurrentMap<PlanNodeId, TaskSource> unpartitionedSources = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    @GuardedBy(value="this")
    private long maxAcknowledgedSplit = Long.MIN_VALUE;
    private final Map<PlanNodeId, DriverSplitRunnerFactory> partitionedDriverFactories;
    @GuardedBy(value="this")
    private final Queue<PlanNodeId> sourceStartOrder;
    @GuardedBy(value="this")
    private final ConcurrentMap<PlanNodeId, TaskSource> pendingSplits = new ConcurrentHashMap<PlanNodeId, TaskSource>();
    private final List<DriverSplitRunnerFactory> unpartitionedDriverFactories;

    public static SqlTaskExecution createSqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, PlanFragment fragment, List<TaskSource> sources, LocalExecutionPlanner planner, TaskExecutor taskExecutor, Executor notificationExecutor, QueryMonitor queryMonitor) {
        SqlTaskExecution task = new SqlTaskExecution(taskStateMachine, taskContext, outputBuffer, fragment, planner, taskExecutor, queryMonitor, notificationExecutor);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{task.getTaskId()});){
            task.start();
            task.addSources(sources);
            SqlTaskExecution sqlTaskExecution = task;
            return sqlTaskExecution;
        }
    }

    private SqlTaskExecution(TaskStateMachine taskStateMachine, TaskContext taskContext, OutputBuffer outputBuffer, PlanFragment fragment, LocalExecutionPlanner planner, TaskExecutor taskExecutor, QueryMonitor queryMonitor, Executor notificationExecutor) {
        this.taskStateMachine = Objects.requireNonNull(taskStateMachine, "taskStateMachine is null");
        this.taskId = taskStateMachine.getTaskId();
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "driverExecutor is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            List<DriverFactory> driverFactories;
            try {
                LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(taskContext.getSession(), fragment.getRoot(), fragment.getSymbols(), fragment.getPartitioningScheme(), outputBuffer);
                driverFactories = localExecutionPlan.getDriverFactories();
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                throw Throwables.propagate((Throwable)e);
            }
            ImmutableMap.Builder partitionedDriverFactories = ImmutableMap.builder();
            ImmutableList.Builder unpartitionedDriverFactories = ImmutableList.builder();
            for (DriverFactory driverFactory : driverFactories) {
                Optional<PlanNodeId> sourceId = driverFactory.getSourceId();
                if (sourceId.isPresent() && fragment.isPartitionedSources(sourceId.get())) {
                    partitionedDriverFactories.put((Object)sourceId.get(), (Object)new DriverSplitRunnerFactory(driverFactory));
                    continue;
                }
                unpartitionedDriverFactories.add((Object)new DriverSplitRunnerFactory(driverFactory));
            }
            this.partitionedDriverFactories = partitionedDriverFactories.build();
            this.unpartitionedDriverFactories = unpartitionedDriverFactories.build();
            this.sourceStartOrder = new ArrayDeque<PlanNodeId>(fragment.getPartitionedSources());
            Preconditions.checkArgument((boolean)this.partitionedDriverFactories.keySet().equals(ImmutableSet.copyOf(fragment.getPartitionedSources())), (Object)"Fragment us partitioned, but all partitioned drivers were not found");
            if (!taskStateMachine.getState().isDone()) {
                this.taskHandle = taskExecutor.addTask(this.taskId, outputBuffer::getUtilization, SystemSessionProperties.getInitialSplitsPerNode(taskContext.getSession()), SystemSessionProperties.getSplitConcurrencyAdjustmentInterval(taskContext.getSession()));
                taskStateMachine.addStateChangeListener(new RemoveTaskHandleWhenDone(taskExecutor, this.taskHandle));
                taskStateMachine.addStateChangeListener(state -> {
                    if (state.isDone()) {
                        for (DriverFactory factory : driverFactories) {
                            factory.close();
                        }
                    }
                });
            } else {
                this.taskHandle = null;
            }
            outputBuffer.addStateChangeListener(new CheckTaskCompletionOnBufferFinish(this));
        }
    }

    private void start() {
        ArrayList<DriverSplitRunner> runners = new ArrayList<DriverSplitRunner>();
        for (DriverSplitRunnerFactory driverFactory : this.unpartitionedDriverFactories) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                runners.add(driverFactory.createDriverRunner(null, false));
            }
            driverFactory.setNoMoreSplits();
        }
        this.enqueueDrivers(true, runners);
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    public void addSources(List<TaskSource> sources) {
        Objects.requireNonNull(sources, "sources is null");
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (String)"Can not add sources while holding a lock on the %s", (Object)this.getClass().getSimpleName());
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            Map<PlanNodeId, TaskSource> updatedUnpartitionedSources = this.updateSources(sources);
            for (TaskSource source : updatedUnpartitionedSources.values()) {
                for (WeakReference<Driver> driverReference : this.drivers) {
                    Driver driver = (Driver)driverReference.get();
                    if (driver != null) {
                        driver.updateSource(source);
                        continue;
                    }
                    this.drivers.remove(driverReference);
                }
            }
            this.checkTaskCompletion();
        }
    }

    private synchronized Map<PlanNodeId, TaskSource> updateSources(List<TaskSource> sources) {
        HashMap<PlanNodeId, TaskSource> updatedUnpartitionedSources = new HashMap<PlanNodeId, TaskSource>();
        long currentMaxAcknowledgedSplit = this.maxAcknowledgedSplit;
        sources = sources.stream().map(source -> new TaskSource(source.getPlanNodeId(), source.getSplits().stream().filter(scheduledSplit -> scheduledSplit.getSequenceId() > currentMaxAcknowledgedSplit).collect(Collectors.toSet()), source.isNoMoreSplits())).collect(Collectors.toList());
        for (TaskSource source2 : sources) {
            if (this.partitionedDriverFactories.containsKey(source2.getPlanNodeId())) {
                this.schedulePartitionedSource(source2);
                continue;
            }
            this.scheduleUnpartitionedSource(source2, updatedUnpartitionedSources);
        }
        this.maxAcknowledgedSplit = sources.stream().flatMap(source -> source.getSplits().stream()).mapToLong(ScheduledSplit::getSequenceId).max().orElse(this.maxAcknowledgedSplit);
        return updatedUnpartitionedSources;
    }

    private synchronized void schedulePartitionedSource(TaskSource source) {
        if (!this.isSchedulingSource(source.getPlanNodeId())) {
            this.pendingSplits.merge(source.getPlanNodeId(), source, TaskSource::update);
            return;
        }
        DriverSplitRunnerFactory partitionedDriverFactory = this.partitionedDriverFactories.get(source.getPlanNodeId());
        ImmutableList.Builder runners = ImmutableList.builder();
        for (ScheduledSplit scheduledSplit : source.getSplits()) {
            runners.add((Object)partitionedDriverFactory.createDriverRunner(scheduledSplit, true));
        }
        this.enqueueDrivers(false, (List<DriverSplitRunner>)runners.build());
        if (source.isNoMoreSplits()) {
            TaskSource nextSource;
            partitionedDriverFactory.setNoMoreSplits();
            this.sourceStartOrder.remove(source.getPlanNodeId());
            if (!this.sourceStartOrder.isEmpty() && (nextSource = (TaskSource)this.pendingSplits.get(this.sourceStartOrder.peek())) != null) {
                this.schedulePartitionedSource(nextSource);
            }
        }
    }

    private synchronized boolean isSchedulingSource(PlanNodeId sourceId) {
        return !this.sourceStartOrder.isEmpty() && this.sourceStartOrder.peek().equals(sourceId);
    }

    private synchronized void scheduleUnpartitionedSource(TaskSource source, Map<PlanNodeId, TaskSource> updatedUnpartitionedSources) {
        TaskSource currentSource = (TaskSource)this.unpartitionedSources.get(source.getPlanNodeId());
        TaskSource newSource = currentSource == null ? source : currentSource.update(source);
        if (newSource != currentSource) {
            this.unpartitionedSources.put(source.getPlanNodeId(), newSource);
            updatedUnpartitionedSources.put(source.getPlanNodeId(), newSource);
        }
    }

    private synchronized void enqueueDrivers(boolean forceRunSplit, List<DriverSplitRunner> runners) {
        List<ListenableFuture<?>> finishedFutures = this.taskExecutor.enqueueSplits(this.taskHandle, forceRunSplit, runners);
        Preconditions.checkState((finishedFutures.size() == runners.size() ? 1 : 0) != 0, (String)"Expected %s futures but got %s", (int)runners.size(), (int)finishedFutures.size());
        this.remainingDrivers.addAndGet(finishedFutures.size());
        for (int i = 0; i < finishedFutures.size(); ++i) {
            ListenableFuture<?> finishedFuture = finishedFutures.get(i);
            final DriverSplitRunner splitRunner = runners.get(i);
            Futures.addCallback(finishedFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.remainingDrivers.decrementAndGet();
                        SqlTaskExecution.this.checkTaskCompletion();
                        SqlTaskExecution.this.queryMonitor.splitCompletedEvent(SqlTaskExecution.this.taskId, this.getDriverStats());
                    }
                }

                public void onFailure(Throwable cause) {
                    try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{SqlTaskExecution.this.taskId});){
                        SqlTaskExecution.this.taskStateMachine.failed(cause);
                        SqlTaskExecution.this.remainingDrivers.decrementAndGet();
                        SqlTaskExecution.this.queryMonitor.splitFailedEvent(SqlTaskExecution.this.taskId, this.getDriverStats(), cause);
                    }
                }

                private DriverStats getDriverStats() {
                    DriverContext driverContext = splitRunner.getDriverContext();
                    DriverStats driverStats = driverContext != null ? driverContext.getDriverStats() : new DriverStats();
                    return driverStats;
                }
            }, (Executor)this.notificationExecutor);
        }
    }

    public synchronized Set<PlanNodeId> getNoMoreSplits() {
        ImmutableSet.Builder noMoreSplits = ImmutableSet.builder();
        for (Map.Entry<PlanNodeId, DriverSplitRunnerFactory> entry : this.partitionedDriverFactories.entrySet()) {
            if (!entry.getValue().isNoMoreSplits()) continue;
            noMoreSplits.add((Object)entry.getKey());
        }
        for (TaskSource taskSource : this.unpartitionedSources.values()) {
            if (!taskSource.isNoMoreSplits()) continue;
            noMoreSplits.add((Object)taskSource.getPlanNodeId());
        }
        return noMoreSplits.build();
    }

    private synchronized void checkTaskCompletion() {
        if (this.taskStateMachine.getState().isDone()) {
            return;
        }
        if (!this.partitionedDriverFactories.values().stream().allMatch(rec$ -> ((DriverSplitRunnerFactory)rec$).isNoMoreSplits())) {
            return;
        }
        if (this.remainingDrivers.get() != 0) {
            return;
        }
        this.outputBuffer.setNoMorePages();
        if (!this.outputBuffer.isFinished()) {
            return;
        }
        this.taskStateMachine.finished();
    }

    public void cancel() {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            this.taskStateMachine.cancel();
        }
    }

    public void fail(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{this.taskId});){
            this.taskStateMachine.failed(cause);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("remainingDrivers", (Object)this.remainingDrivers).add("unpartitionedSources", this.unpartitionedSources).toString();
    }

    private static final class CheckTaskCompletionOnBufferFinish
    implements StateMachine.StateChangeListener<BufferState> {
        private final WeakReference<SqlTaskExecution> sqlTaskExecutionReference;

        public CheckTaskCompletionOnBufferFinish(SqlTaskExecution sqlTaskExecution) {
            this.sqlTaskExecutionReference = new WeakReference<SqlTaskExecution>(sqlTaskExecution);
        }

        @Override
        public void stateChanged(BufferState newState) {
            SqlTaskExecution sqlTaskExecution;
            if (newState == BufferState.FINISHED && (sqlTaskExecution = (SqlTaskExecution)this.sqlTaskExecutionReference.get()) != null) {
                sqlTaskExecution.checkTaskCompletion();
            }
        }
    }

    private static final class RemoveTaskHandleWhenDone
    implements StateMachine.StateChangeListener<TaskState> {
        private final TaskExecutor taskExecutor;
        private final TaskExecutor.TaskHandle taskHandle;

        private RemoveTaskHandleWhenDone(TaskExecutor taskExecutor, TaskExecutor.TaskHandle taskHandle) {
            this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
            this.taskHandle = Objects.requireNonNull(taskHandle, "taskHandle is null");
        }

        @Override
        public void stateChanged(TaskState newState) {
            if (newState.isDone()) {
                this.taskExecutor.removeTask(this.taskHandle);
            }
        }
    }

    private static class DriverSplitRunner
    implements SplitRunner {
        private final DriverSplitRunnerFactory driverSplitRunnerFactory;
        private final DriverContext driverContext;
        @GuardedBy(value="this")
        private boolean closed;
        @Nullable
        private final ScheduledSplit partitionedSplit;
        @GuardedBy(value="this")
        private Driver driver;

        private DriverSplitRunner(DriverSplitRunnerFactory driverSplitRunnerFactory, DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            this.driverSplitRunnerFactory = Objects.requireNonNull(driverSplitRunnerFactory, "driverFactory is null");
            this.driverContext = Objects.requireNonNull(driverContext, "driverContext is null");
            this.partitionedSplit = partitionedSplit;
        }

        public synchronized DriverContext getDriverContext() {
            if (this.driver == null) {
                return null;
            }
            return this.driver.getDriverContext();
        }

        @Override
        public synchronized boolean isFinished() {
            if (this.closed) {
                return true;
            }
            if (this.driver == null) {
                return false;
            }
            return this.driver.isFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListenableFuture<?> processFor(Duration duration) {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                if (this.closed) {
                    return Futures.immediateFuture(null);
                }
                if (this.driver == null) {
                    this.driver = this.driverSplitRunnerFactory.createDriver(this.driverContext, this.partitionedSplit);
                }
                driver = this.driver;
            }
            return driver.processFor(duration);
        }

        @Override
        public String getInfo() {
            return this.partitionedSplit == null ? "" : this.partitionedSplit.getSplit().getInfo().toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Driver driver;
            DriverSplitRunner driverSplitRunner = this;
            synchronized (driverSplitRunner) {
                this.closed = true;
                driver = this.driver;
            }
            if (driver != null) {
                driver.close();
            }
        }
    }

    private class DriverSplitRunnerFactory {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final AtomicInteger pendingCreation = new AtomicInteger();
        private final AtomicBoolean noMoreSplits = new AtomicBoolean();

        private DriverSplitRunnerFactory(DriverFactory driverFactory) {
            this.driverFactory = driverFactory;
            this.pipelineContext = SqlTaskExecution.this.taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver());
        }

        private DriverSplitRunner createDriverRunner(@Nullable ScheduledSplit partitionedSplit, boolean partitioned) {
            this.pendingCreation.incrementAndGet();
            DriverContext driverContext = this.pipelineContext.addDriverContext(partitioned);
            return new DriverSplitRunner(this, driverContext, partitionedSplit);
        }

        private Driver createDriver(DriverContext driverContext, @Nullable ScheduledSplit partitionedSplit) {
            Driver driver = this.driverFactory.createDriver(driverContext);
            SqlTaskExecution.this.drivers.add(new WeakReference<Driver>(driver));
            if (partitionedSplit != null) {
                driver.updateSource(new TaskSource(partitionedSplit.getPlanNodeId(), (Set<ScheduledSplit>)ImmutableSet.of((Object)partitionedSplit), true));
            }
            for (TaskSource source : SqlTaskExecution.this.unpartitionedSources.values()) {
                driver.updateSource(source);
            }
            this.pendingCreation.decrementAndGet();
            this.closeDriverFactoryIfFullyCreated();
            return driver;
        }

        private boolean isNoMoreSplits() {
            return this.noMoreSplits.get();
        }

        private void setNoMoreSplits() {
            this.noMoreSplits.set(true);
            this.closeDriverFactoryIfFullyCreated();
        }

        private void closeDriverFactoryIfFullyCreated() {
            if (this.isNoMoreSplits() && this.pendingCreation.get() <= 0) {
                this.driverFactory.close();
            }
        }

        public OptionalInt getDriverInstances() {
            return this.driverFactory.getDriverInstances();
        }
    }
}

