/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.ColumnDefinition;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TableElement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CreateTableTask
implements DataDefinitionTask<CreateTable> {
    @Override
    public String getName() {
        return "CREATE TABLE";
    }

    @Override
    public String explain(CreateTable statement, List<Expression> parameters) {
        return "CREATE TABLE " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Preconditions.checkArgument((!statement.getElements().isEmpty() ? 1 : 0) != 0, (Object)"no columns for table");
        Session session = stateMachine.getSession();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
        if (tableHandle.isPresent()) {
            if (!statement.isNotExists()) {
                throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table '%s' already exists", tableName);
            }
            return Futures.immediateFuture(null);
        }
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        Object inheritedProperties = ImmutableMap.of();
        boolean includingProperties = false;
        for (TableElement element : statement.getElements()) {
            if (element instanceof ColumnDefinition) {
                ColumnDefinition column2 = (ColumnDefinition)element;
                Type type = metadata.getType(TypeSignature.parseTypeSignature((String)column2.getType()));
                if (type == null || type.equals((Object)UnknownType.UNKNOWN)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)column2, "Unknown type for column '%s' ", column2.getName());
                }
                columns.add(new ColumnMetadata(column2.getName(), type, (String)column2.getComment().orElse(null), false));
                continue;
            }
            if (element instanceof LikeClause) {
                LikeClause likeClause = (LikeClause)element;
                QualifiedObjectName likeTableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, likeClause.getTableName());
                if (!metadata.getCatalogHandle(session, likeTableName.getCatalogName()).isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "LIKE table catalog '%s' does not exist", likeTableName.getCatalogName());
                }
                if (!tableName.getCatalogName().equals(likeTableName.getCatalogName())) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "LIKE table across catalogs is not supported", new Object[0]);
                }
                TableHandle likeTable = metadata.getTableHandle(session, likeTableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "LIKE table '%s' does not exist", likeTableName));
                TableMetadata likeTableMetadata = metadata.getTableMetadata(session, likeTable);
                Optional propertiesOption = likeClause.getPropertiesOption();
                if (propertiesOption.isPresent() && ((LikeClause.PropertiesOption)propertiesOption.get()).equals((Object)LikeClause.PropertiesOption.INCLUDING)) {
                    if (includingProperties) {
                        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Only one LIKE clause can specify INCLUDING PROPERTIES", new Object[0]);
                    }
                    includingProperties = true;
                    inheritedProperties = likeTableMetadata.getMetadata().getProperties();
                }
                likeTableMetadata.getColumns().stream().filter(column -> !column.isHidden()).forEach(columns::add);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Invalid TableElement: " + element.getClass().getName());
        }
        accessControl.checkCanCreateTable(session.getRequiredTransactionId(), session.getIdentity(), tableName);
        ConnectorId connectorId = metadata.getCatalogHandle(session, tableName.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + tableName.getCatalogName()));
        Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(connectorId, tableName.getCatalogName(), statement.getProperties(), session, metadata, parameters);
        Map<String, Object> finalProperties = CreateTableTask.combineProperties(statement.getProperties().keySet(), properties, (Map<String, Object>)inheritedProperties);
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), columns, finalProperties);
        metadata.createTable(session, tableName.getCatalogName(), tableMetadata);
        return Futures.immediateFuture(null);
    }

    private static Map<String, Object> combineProperties(Set<String> specifiedPropertyKeys, Map<String, Object> defaultProperties, Map<String, Object> inheritedProperties) {
        HashMap<String, Object> finalProperties = new HashMap<String, Object>();
        finalProperties.putAll(inheritedProperties);
        for (Map.Entry<String, Object> entry : defaultProperties.entrySet()) {
            if (!specifiedPropertyKeys.contains(entry.getKey()) && finalProperties.containsKey(entry.getKey())) continue;
            finalProperties.put(entry.getKey(), entry.getValue());
        }
        return finalProperties;
    }
}

