/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SystemTableHandle
implements ConnectorTableHandle {
    private final ConnectorId connectorId;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public SystemTableHandle(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
    }

    public static SystemTableHandle fromSchemaTableName(ConnectorId connectorId, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        return new SystemTableHandle(connectorId, tableName.getSchemaName(), tableName.getTableName());
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public String toString() {
        return this.connectorId + ":" + this.schemaName + "." + this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemTableHandle other = (SystemTableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }
}

