/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockSerdeUtil;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Base64;
import java.util.Objects;
import javax.inject.Inject;

public final class BlockJsonSerde {
    private BlockJsonSerde() {
    }

    public static class Deserializer
    extends JsonDeserializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;

        @Inject
        public Deserializer(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public Block deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            byte[] decoded = Base64.getDecoder().decode((String)jsonParser.readValueAs(String.class));
            return BlockSerdeUtil.readBlock(this.blockEncodingSerde, Slices.wrappedBuffer((byte[])decoded));
        }
    }

    public static class Serializer
    extends JsonSerializer<Block> {
        private final BlockEncodingSerde blockEncodingSerde;

        @Inject
        public Serializer(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        }

        public void serialize(Block block, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            DynamicSliceOutput output = new DynamicSliceOutput(64);
            BlockSerdeUtil.writeBlock(this.blockEncodingSerde, (SliceOutput)output, block);
            String encoded = Base64.getEncoder().encodeToString(output.slice().getBytes());
            jsonGenerator.writeString(encoded);
        }
    }
}

