/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class RelationPlan {
    private final PlanNode root;
    private final List<Symbol> fieldMappings;
    private final Scope scope;

    public RelationPlan(PlanNode root, Scope scope, List<Symbol> fieldMappings) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(fieldMappings, "outputSymbols is null");
        Objects.requireNonNull(scope, "scope is null");
        Preconditions.checkArgument((scope.getRelationType().getAllFieldCount() == fieldMappings.size() ? 1 : 0) != 0, (String)"Number of outputs (%s) doesn't match scope size (%s)", (Object[])new Object[]{fieldMappings.size(), scope.getRelationType().getAllFieldCount()});
        this.root = root;
        this.scope = scope;
        this.fieldMappings = ImmutableList.copyOf(fieldMappings);
    }

    public Symbol getSymbol(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.fieldMappings.size() && this.fieldMappings.get(fieldIndex) != null ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (Object[])new Object[]{fieldIndex});
        return this.fieldMappings.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<Symbol> getFieldMappings() {
        return this.fieldMappings;
    }

    public RelationType getDescriptor() {
        return this.scope.getRelationType();
    }

    public Scope getScope() {
        return this.scope;
    }
}

