/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.planner.ParameterRewriter;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class QueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final IdentityHashMap<LambdaArgumentDeclaration, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final Session session;
    private final SubqueryPlanner subqueryPlanner;

    QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, IdentityHashMap<LambdaArgumentDeclaration, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.session = session;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, lambdaDeclarationToSymbolMap, metadata, session, analysis.getParameters());
    }

    public RelationPlan plan(Query query) {
        PlanBuilder builder = this.planQueryBody(query);
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, orderBy);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, outputs);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.sort(builder, query);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)query));
        builder = this.limit(builder, query);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)query), QueryPlanner.computeOutputs(builder, this.analysis.getOutputExpressions((Node)query)));
    }

    public RelationPlan plan(QuerySpecification node) {
        PlanBuilder builder = this.planFrom(node);
        builder = this.filter(builder, this.analysis.getWhere(node), (Node)node);
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node), (Node)node);
        builder = this.window(builder, node);
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, orderBy);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, outputs);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.distinct(builder, node, outputs, orderBy);
        builder = this.sort(builder, node);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)node));
        builder = this.limit(builder, node);
        return new RelationPlan(builder.getRoot(), this.analysis.getScope((Node)node), QueryPlanner.computeOutputs(builder, this.analysis.getOutputExpressions((Node)node)));
    }

    public DeleteNode plan(Delete node) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node.getTable());
        TableHandle handle = this.analysis.getTableHandle(node.getTable());
        ColumnHandle rowIdHandle = this.metadata.getUpdateRowIdColumnHandle(this.session, handle);
        Type rowIdType = this.metadata.getColumnMetadata(this.session, handle, rowIdHandle).getType();
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Field field : descriptor.getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbols.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
            fields.add((Object)field);
        }
        Field rowIdField = Field.newUnqualified(Optional.empty(), rowIdType);
        Symbol rowIdSymbol = this.symbolAllocator.newSymbol("$rowId", rowIdField.getType());
        outputSymbols.add((Object)rowIdSymbol);
        columns.put((Object)rowIdSymbol, (Object)rowIdHandle);
        fields.add((Object)rowIdField);
        TableScanNode tableScan = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols.build(), (Map<Symbol, ColumnHandle>)columns.build(), Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all(), null);
        Scope scope = Scope.builder().withRelationType(new RelationType((List<Field>)fields.build())).build();
        RelationPlan relationPlan = new RelationPlan(tableScan, scope, (List<Symbol>)outputSymbols.build());
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        PlanBuilder builder = new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get(), (Node)node);
        }
        Symbol rowId = builder.translate((Expression)new FieldReference(relationPlan.getDescriptor().indexOf(rowIdField)));
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        return new DeleteNode(this.idAllocator.getNextId(), builder.getRoot(), new TableWriterNode.DeleteHandle(handle, this.metadata.getTableMetadata(this.session, handle).getTable()), rowId, (List<Symbol>)outputs);
    }

    private static List<Symbol> computeOutputs(PlanBuilder builder, List<Expression> outputExpressions) {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (Expression expression : outputExpressions) {
            outputSymbols.add((Object)builder.translate(expression));
        }
        return outputSymbols.build();
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).process((Node)query.getQueryBody(), null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        RelationPlan relationPlan = node.getFrom().isPresent() ? (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).process((Node)node.getFrom().get(), null) : this.planImplicitTable(node);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        return new PlanBuilder(translations, relationPlan.getRoot(), this.analysis.getParameters());
    }

    private RelationPlan planImplicitTable(QuerySpecification node) {
        ImmutableList emptyRow = ImmutableList.of();
        Scope scope = Scope.builder().withParent(this.analysis.getScope((Node)node)).build();
        return new RelationPlan(new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)emptyRow)), scope, (List<Symbol>)ImmutableList.of());
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate, Node node) {
        if (predicate == null) {
            return subPlan;
        }
        predicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)predicate);
        Expression rewrittenBeforeSubqueries = subPlan.rewrite(predicate);
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, rewrittenBeforeSubqueries, node);
        predicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)predicate);
        Expression rewrittenAfterSubqueries = subPlan.rewrite(predicate);
        return subPlan.withNewRoot(new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), rewrittenAfterSubqueries));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        Assignments.Builder projections = Assignments.builder();
        for (Expression expression : expressions) {
            Expression rewritten = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
            Symbol symbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getTypeWithCoercions(expression));
            projections.put(symbol, subPlan.rewrite(rewritten));
            outputTranslations.addIntermediateMapping(expression, rewritten);
            outputTranslations.put(rewritten, symbol);
        }
        return new PlanBuilder(outputTranslations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projections.build()), this.analysis.getParameters());
    }

    private Map<Symbol, Expression> coerce(Iterable<? extends Expression> expressions, PlanBuilder subPlan, TranslationMap translations) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type type = this.analysis.getType(expression);
            Type coercion = this.analysis.getCoercion(expression);
            Symbol symbol = this.symbolAllocator.newSymbol(expression, (Type)MoreObjects.firstNonNull((Object)coercion, (Object)type));
            Expression parametersReplaced = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
            translations.addIntermediateMapping(expression, parametersReplaced);
            Expression rewritten = subPlan.rewrite(expression);
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.metadata.getTypeManager().isTypeOnlyCoercion(type, coercion));
            }
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(parametersReplaced, symbol);
        }
        return projections.build();
    }

    private PlanBuilder explicitCoercionFields(PlanBuilder subPlan, Iterable<Expression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        Assignments.Builder projections = Assignments.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Expression expression : alreadyCoerced) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            Expression parametersReplaced = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
            translations.addIntermediateMapping(expression, parametersReplaced);
            Expression rewritten = subPlan.rewrite(expression);
            projections.put(symbol, rewritten);
            translations.put(parametersReplaced, symbol);
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), projections.build()), this.analysis.getParameters());
    }

    private PlanBuilder explicitCoercionSymbols(PlanBuilder subPlan, Iterable<Symbol> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = subPlan.copyTranslations();
        Assignments assignments = Assignments.builder().putAll(this.coerce(uncoerced, subPlan, translations)).putAll(Assignments.identity(alreadyCoerced)).build();
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments), this.analysis.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        List<List<Expression>> groupingSets = this.analysis.getGroupingSets(node);
        if (groupingSets.isEmpty()) {
            return subPlan;
        }
        Set distinctGroupingColumns = (Set)groupingSets.stream().flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableSet());
        ImmutableList.Builder arguments = ImmutableList.builder();
        this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        this.analysis.getAggregates(node).stream().map(FunctionCall::getFilter).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
        Iterable inputs = Iterables.concat((Iterable)distinctGroupingColumns, (Iterable)arguments.build());
        subPlan = this.handleSubqueries(subPlan, (Node)node, inputs);
        if (!Iterables.isEmpty((Iterable)inputs)) {
            subPlan = this.project(subPlan, inputs);
        }
        TranslationMap argumentTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        ImmutableMap.Builder argumentMappingBuilder = ImmutableMap.builder();
        for (Expression argument : arguments.build()) {
            Expression parametersReplaced = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)argument);
            argumentTranslations.addIntermediateMapping(argument, parametersReplaced);
            Symbol input = subPlan.translate(parametersReplaced);
            if (argumentTranslations.containsSymbol(parametersReplaced)) continue;
            Symbol output = this.symbolAllocator.newSymbol(parametersReplaced, this.analysis.getTypeWithCoercions(parametersReplaced), "arg");
            argumentMappingBuilder.put((Object)output, (Object)input);
            argumentTranslations.put(parametersReplaced, output);
        }
        ImmutableMap argumentMappings = argumentMappingBuilder.build();
        TranslationMap groupingTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        HashMap<Symbol, Symbol> groupingSetMappings = new HashMap<Symbol, Symbol>();
        ArrayList<List<Symbol>> groupingSymbols = new ArrayList<List<Symbol>>();
        for (List<Expression> groupingSet : groupingSets) {
            ImmutableList.Builder symbols = ImmutableList.builder();
            for (Expression expression : groupingSet) {
                Symbol output;
                Expression parametersReplaced = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)expression);
                groupingTranslations.addIntermediateMapping(expression, parametersReplaced);
                Symbol input = subPlan.translate(expression);
                if (!groupingTranslations.containsSymbol(parametersReplaced)) {
                    output = this.symbolAllocator.newSymbol(parametersReplaced, this.analysis.getTypeWithCoercions(expression), "gid");
                    groupingTranslations.put(parametersReplaced, output);
                } else {
                    output = groupingTranslations.get(parametersReplaced);
                }
                groupingSetMappings.put(output, input);
                symbols.add((Object)output);
            }
            groupingSymbols.add((List<Symbol>)symbols.build());
        }
        Optional<Object> groupIdSymbol = Optional.empty();
        if (groupingSets.size() > 1) {
            groupIdSymbol = Optional.of(this.symbolAllocator.newSymbol("groupId", (Type)BigintType.BIGINT));
            GroupIdNode groupId = new GroupIdNode(this.idAllocator.getNextId(), subPlan.getRoot(), groupingSymbols, groupingSetMappings, (Map<Symbol, Symbol>)argumentMappings, (Symbol)groupIdSymbol.get());
            subPlan = new PlanBuilder(groupingTranslations, groupId, this.analysis.getParameters());
        } else {
            Assignments.Builder assignments = Assignments.builder();
            for (Symbol output : argumentMappings.keySet()) {
                assignments.put(output, (Expression)((Symbol)argumentMappings.get(output)).toSymbolReference());
            }
            for (Symbol output : groupingSetMappings.keySet()) {
                assignments.put(output, (Expression)((Symbol)groupingSetMappings.get(output)).toSymbolReference());
            }
            ProjectNode project = new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments.build());
            subPlan = new PlanBuilder(groupingTranslations, project, this.analysis.getParameters());
        }
        TranslationMap aggregationTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis, this.lambdaDeclarationToSymbolMap);
        aggregationTranslations.copyMappingsFrom(groupingTranslations);
        ImmutableMap.Builder aggregationAssignments = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        boolean needPostProjectionCoercion = false;
        for (FunctionCall aggregate : this.analysis.getAggregates(node)) {
            void var21_22;
            Expression parametersReplaced = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)aggregate);
            aggregationTranslations.addIntermediateMapping((Expression)aggregate, parametersReplaced);
            Expression expression = argumentTranslations.rewrite(parametersReplaced);
            Symbol newSymbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType((Expression)aggregate));
            if (expression instanceof Cast) {
                Expression expression2 = ((Cast)expression).getExpression();
                needPostProjectionCoercion = true;
            }
            aggregationAssignments.put((Object)newSymbol, (Object)((FunctionCall)var21_22));
            aggregationTranslations.put(parametersReplaced, newSymbol);
            functions.put((Object)newSymbol, (Object)this.analysis.getFunctionSignature(aggregate));
        }
        HashMap<ImmutableSet, Symbol> argumentMarkers = new HashMap<ImmutableSet, Symbol>();
        HashMap<Symbol, Symbol> masks = new HashMap<Symbol, Symbol>();
        for (FunctionCall functionCall : Iterables.filter(this.analysis.getAggregates(node), FunctionCall::isDistinct)) {
            ImmutableSet args = ImmutableSet.copyOf((Collection)functionCall.getArguments());
            Symbol marker = (Symbol)argumentMarkers.get(args);
            Symbol aggregateSymbol = aggregationTranslations.get((Expression)functionCall);
            if (marker == null) {
                marker = args.size() == 1 ? this.symbolAllocator.newSymbol((Expression)Iterables.getOnlyElement((Iterable)args), (Type)BooleanType.BOOLEAN, "distinct") : this.symbolAllocator.newSymbol(aggregateSymbol.getName(), (Type)BooleanType.BOOLEAN, "distinct");
                argumentMarkers.put(args, marker);
            }
            masks.put(aggregateSymbol, marker);
        }
        for (Map.Entry entry : argumentMarkers.entrySet()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)groupingSymbols.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
            groupIdSymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            for (Expression expression : (Set)entry.getKey()) {
                builder.add((Object)argumentTranslations.get(expression));
            }
            subPlan = subPlan.withNewRoot(new MarkDistinctNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Symbol)entry.getValue(), (List<Symbol>)builder.build(), Optional.empty()));
        }
        AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, FunctionCall>)aggregationAssignments.build(), (Map<Symbol, Signature>)functions.build(), masks, groupingSymbols, AggregationNode.Step.SINGLE, Optional.empty(), groupIdSymbol);
        subPlan = new PlanBuilder(aggregationTranslations, aggregationNode, this.analysis.getParameters());
        if (needPostProjectionCoercion) {
            return this.explicitCoercionFields(subPlan, distinctGroupingColumns, this.analysis.getAggregates(node));
        }
        return subPlan;
    }

    private PlanBuilder window(PlanBuilder subPlan, QuerySpecification node) {
        ImmutableList windowFunctions = ImmutableList.copyOf(this.analysis.getWindowFunctions(node));
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        for (FunctionCall windowFunction : windowFunctions) {
            Object expression2;
            Window window = (Window)windowFunction.getWindow().get();
            WindowFrame.Type frameType = WindowFrame.Type.RANGE;
            FrameBound.Type frameStartType = FrameBound.Type.UNBOUNDED_PRECEDING;
            FrameBound.Type frameEndType = FrameBound.Type.CURRENT_ROW;
            Expression frameStart = null;
            Expression frameEnd = null;
            if (window.getFrame().isPresent()) {
                WindowFrame frame = (WindowFrame)window.getFrame().get();
                frameType = frame.getType();
                frameStartType = frame.getStart().getType();
                frameStart = frame.getStart().getValue().orElse(null);
                if (frame.getEnd().isPresent()) {
                    frameEndType = ((FrameBound)frame.getEnd().get()).getType();
                    frameEnd = ((FrameBound)frame.getEnd().get()).getValue().orElse(null);
                }
            }
            ImmutableList.Builder inputs = ImmutableList.builder().addAll((Iterable)windowFunction.getArguments()).addAll((Iterable)window.getPartitionBy()).addAll(Iterables.transform((Iterable)window.getOrderBy(), SortItem::getSortKey));
            if (frameStart != null) {
                inputs.add(frameStart);
            }
            if (frameEnd != null) {
                inputs.add(frameEnd);
            }
            subPlan = subPlan.appendProjections((Iterable<Expression>)inputs.build(), this.symbolAllocator, this.idAllocator);
            ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
            for (Object expression2 : window.getPartitionBy()) {
                partitionBySymbols.add((Object)subPlan.translate((Expression)expression2));
            }
            LinkedHashMap<Symbol, SortOrder> orderings = new LinkedHashMap<Symbol, SortOrder>();
            expression2 = window.getOrderBy().iterator();
            while (expression2.hasNext()) {
                SortItem item = (SortItem)expression2.next();
                Symbol symbol = subPlan.translate(item.getSortKey());
                orderings.put(symbol, QueryPlanner.toSortOrder(item));
            }
            Optional<Symbol> frameStartSymbol = Optional.empty();
            Optional<Symbol> frameEndSymbol = Optional.empty();
            if (frameStart != null) {
                frameStartSymbol = Optional.of(subPlan.translate(frameStart));
            }
            if (frameEnd != null) {
                frameEndSymbol = Optional.of(subPlan.translate(frameEnd));
            }
            WindowNode.Frame frame = new WindowNode.Frame(frameType, frameStartType, frameStartSymbol, frameEndType, frameEndSymbol);
            TranslationMap outputTranslations = subPlan.copyTranslations();
            Expression parametersReplaced = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)windowFunction);
            outputTranslations.addIntermediateMapping((Expression)windowFunction, parametersReplaced);
            Expression rewritten = subPlan.rewrite(parametersReplaced);
            boolean needCoercion = rewritten instanceof Cast;
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
            }
            if (rewritten instanceof SymbolReference) {
                if (!needCoercion) continue;
                subPlan = this.explicitCoercionSymbols(subPlan, subPlan.getRoot().getOutputSymbols(), (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
                continue;
            }
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)windowFunction));
            outputTranslations.put(parametersReplaced, newSymbol);
            WindowNode.Function function = new WindowNode.Function((FunctionCall)rewritten, this.analysis.getFunctionSignature(windowFunction), frame);
            List<Symbol> sourceSymbols = subPlan.getRoot().getOutputSymbols();
            ImmutableList.Builder orderBySymbols = ImmutableList.builder();
            orderBySymbols.addAll(orderings.keySet());
            subPlan = new PlanBuilder(outputTranslations, new WindowNode(this.idAllocator.getNextId(), subPlan.getRoot(), new WindowNode.Specification((List<Symbol>)partitionBySymbols.build(), (List<Symbol>)orderBySymbols.build(), orderings), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)newSymbol, (Object)function), Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0), this.analysis.getParameters());
            if (!needCoercion) continue;
            subPlan = this.explicitCoercionSymbols(subPlan, sourceSymbols, (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
        }
        return subPlan;
    }

    private PlanBuilder handleSubqueries(PlanBuilder subPlan, Node node, Iterable<Expression> inputs) {
        for (Expression input : inputs) {
            input = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ParameterRewriter(this.analysis.getParameters(), this.analysis), (Expression)input);
            Expression rewritten = subPlan.rewrite(input);
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, rewritten, node);
        }
        return subPlan;
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node, List<Expression> outputs, List<Expression> orderBy) {
        if (node.getSelect().isDistinct()) {
            Preconditions.checkState((boolean)outputs.containsAll(orderBy), (Object)"Expected ORDER BY terms to be in SELECT. Broken analysis");
            return subPlan.withNewRoot(new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of(subPlan.getRoot().getOutputSymbols()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()));
        }
        return subPlan;
    }

    private PlanBuilder sort(PlanBuilder subPlan, Query node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, QuerySpecification node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit, List<Expression> orderByExpressions) {
        if (orderBy.isEmpty()) {
            return subPlan;
        }
        Iterator<SortItem> sortItems = orderBy.iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (Expression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            SortItem sortItem = sortItems.next();
            if (orderings.containsKey(symbol)) continue;
            orderBySymbols.add((Object)symbol);
            orderings.put(symbol, QueryPlanner.toSortOrder(sortItem));
        }
        PlanNode planNode = limit.isPresent() && !limit.get().equalsIgnoreCase("all") ? new TopNNode(this.idAllocator.getNextId(), subPlan.getRoot(), Long.parseLong(limit.get()), (List<Symbol>)orderBySymbols.build(), orderings, false) : new SortNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)orderBySymbols.build(), orderings);
        return subPlan.withNewRoot(planNode);
    }

    private PlanBuilder limit(PlanBuilder subPlan, Query node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, QuerySpecification node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit) {
        if (orderBy.isEmpty() && limit.isPresent() && !limit.get().equalsIgnoreCase("all")) {
            long limitValue = Long.parseLong(limit.get());
            subPlan = subPlan.withNewRoot(new LimitNode(this.idAllocator.getNextId(), subPlan.getRoot(), limitValue, false));
        }
        return subPlan;
    }

    private static SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }
}

