/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.StatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.EvaluateZeroLimit;
import com.facebook.presto.sql.planner.iterative.rule.ImplementBernoulliSampleAsFilter;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithDistinct;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithSort;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimitWithTopN;
import com.facebook.presto.sql.planner.iterative.rule.MergeLimits;
import com.facebook.presto.sql.planner.iterative.rule.PruneTableScanColumns;
import com.facebook.presto.sql.planner.iterative.rule.PruneValuesColumns;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughMarkDistinct;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughProject;
import com.facebook.presto.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import com.facebook.presto.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import com.facebook.presto.sql.planner.iterative.rule.SimplifyCountOverConstant;
import com.facebook.presto.sql.planner.iterative.rule.SingleMarkDistinctToGroupBy;
import com.facebook.presto.sql.planner.iterative.rule.TransformExistsApplyToScalarApply;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.AddLocalExchanges;
import com.facebook.presto.sql.planner.optimizations.BeginTableWrite;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.optimizations.CountConstantOptimizer;
import com.facebook.presto.sql.planner.optimizations.DesugaringOptimizer;
import com.facebook.presto.sql.planner.optimizations.EliminateCrossJoins;
import com.facebook.presto.sql.planner.optimizations.EmptyDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementFilteredAggregations;
import com.facebook.presto.sql.planner.optimizations.ImplementIntersectAndExceptAsUnion;
import com.facebook.presto.sql.planner.optimizations.ImplementSampleAsFilter;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MergeProjections;
import com.facebook.presto.sql.planner.optimizations.MergeWindows;
import com.facebook.presto.sql.planner.optimizations.MetadataDeleteOptimizer;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.OptimizeMixedDistinctAggregations;
import com.facebook.presto.sql.planner.optimizations.PartialAggregationPushDown;
import com.facebook.presto.sql.planner.optimizations.PickLayout;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.ProjectionPushDown;
import com.facebook.presto.sql.planner.optimizations.PruneIdentityProjections;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.PushTableWriteThroughUnion;
import com.facebook.presto.sql.planner.optimizations.RemoveUnreferencedScalarInputApplyNodes;
import com.facebook.presto.sql.planner.optimizations.ReorderWindows;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.SimplifyExpressions;
import com.facebook.presto.sql.planner.optimizations.SingleDistinctOptimizer;
import com.facebook.presto.sql.planner.optimizations.TransformCorrelatedScalarAggregationToJoin;
import com.facebook.presto.sql.planner.optimizations.TransformQuantifiedComparisonApplyToScalarApply;
import com.facebook.presto.sql.planner.optimizations.TransformUncorrelatedInPredicateSubqueryToSemiJoin;
import com.facebook.presto.sql.planner.optimizations.TransformUncorrelatedScalarToJoin;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.MBeanExporter;

public class PlanOptimizers {
    private final List<PlanOptimizer> optimizers;
    private final StatsRecorder stats = new StatsRecorder();
    private final MBeanExporter exporter;

    @Inject
    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, FeaturesConfig featuresConfig, MBeanExporter exporter) {
        this(metadata, sqlParser, featuresConfig, false, exporter);
    }

    @PostConstruct
    public void initialize() {
        this.stats.export(this.exporter);
    }

    @PreDestroy
    public void destroy() {
        this.stats.unexport(this.exporter);
    }

    public PlanOptimizers(Metadata metadata, SqlParser sqlParser, FeaturesConfig featuresConfig, boolean forceSingleNode, MBeanExporter exporter) {
        this.exporter = exporter;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new PlanOptimizer[]{new DesugaringOptimizer(metadata, sqlParser), new CanonicalizeExpressions(), new IterativeOptimizer(this.stats, (Set<Rule>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new EvaluateZeroLimit(), (Object)new PushLimitThroughProject(), (Object)new MergeLimits(), (Object)new MergeLimitWithSort(), (Object)new MergeLimitWithTopN(), (Object[])new Rule[]{new PushLimitThroughMarkDistinct(), new PushLimitThroughSemiJoin(), new MergeLimitWithDistinct(), new PruneValuesColumns(), new PruneTableScanColumns()})), new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new ImplementFilteredAggregations(), (Object)new ImplementSampleAsFilter()), (Set<Rule>)ImmutableSet.of((Object)new com.facebook.presto.sql.planner.iterative.rule.ImplementFilteredAggregations(), (Object)new ImplementBernoulliSampleAsFilter())), new SimplifyExpressions(metadata, sqlParser), new UnaliasSymbolReferences(), new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new PruneIdentityProjections()), (Set<Rule>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new SetFlatteningOptimizer(), new ImplementIntersectAndExceptAsUnion(), new LimitPushDown(), new PruneUnreferencedOutputs(), new MergeProjections(), new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new com.facebook.presto.sql.planner.optimizations.TransformExistsApplyToScalarApply(metadata)), (Set<Rule>)ImmutableSet.of((Object)new TransformExistsApplyToScalarApply(metadata.getFunctionRegistry()))), new TransformQuantifiedComparisonApplyToScalarApply(metadata), new RemoveUnreferencedScalarInputApplyNodes(), new TransformUncorrelatedInPredicateSubqueryToSemiJoin(), new TransformUncorrelatedScalarToJoin(), new TransformCorrelatedScalarAggregationToJoin(metadata), new PredicatePushDown(metadata, sqlParser), new MergeProjections(), new SimplifyExpressions(metadata, sqlParser), new ProjectionPushDown(), new UnaliasSymbolReferences(), new PruneUnreferencedOutputs(), new IndexJoinOptimizer(metadata), new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new CountConstantOptimizer()), (Set<Rule>)ImmutableSet.of((Object)new SimplifyCountOverConstant())), new WindowFilterPushDown(metadata), new MergeWindows(), new ReorderWindows(), new MergeProjections(), new PruneUnreferencedOutputs(), new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new PruneIdentityProjections()), (Set<Rule>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())), new MetadataQueryOptimizer(metadata), new EliminateCrossJoins(), new PredicatePushDown(metadata, sqlParser), new ProjectionPushDown()});
        if (featuresConfig.isOptimizeSingleDistinct()) {
            builder.add((Object[])new PlanOptimizer[]{new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new SingleDistinctOptimizer()), (Set<Rule>)ImmutableSet.of((Object)new SingleMarkDistinctToGroupBy())), new PruneUnreferencedOutputs()});
        }
        builder.add((Object)new OptimizeMixedDistinctAggregations(metadata));
        if (!forceSingleNode) {
            builder.add((Object)new PushTableWriteThroughUnion());
            builder.add((Object)new AddExchanges(metadata, sqlParser));
        }
        builder.add((Object)new PickLayout(metadata));
        builder.add((Object)new EmptyDeleteOptimizer());
        builder.add((Object)new PredicatePushDown(metadata, sqlParser));
        builder.add((Object)new ProjectionPushDown());
        builder.add((Object)new MergeProjections());
        builder.add((Object)new UnaliasSymbolReferences());
        builder.add((Object)new PruneUnreferencedOutputs());
        builder.add((Object)new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new PruneIdentityProjections()), (Set<Rule>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new AddLocalExchanges(metadata, sqlParser));
        builder.add((Object)new PartialAggregationPushDown(metadata.getFunctionRegistry()));
        builder.add((Object)new IterativeOptimizer(this.stats, (List<PlanOptimizer>)ImmutableList.of((Object)new PruneIdentityProjections()), (Set<Rule>)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        builder.add((Object)new HashGenerationOptimizer());
        builder.add((Object)new MetadataDeleteOptimizer(metadata));
        builder.add((Object)new BeginTableWrite(metadata));
        this.optimizers = builder.build();
    }

    public List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

