/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class FunctionInvoker {
    private final FunctionRegistry registry;

    public FunctionInvoker(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    public Object invoke(Signature function, ConnectorSession session, Object ... arguments) {
        return this.invoke(function, session, Arrays.asList(arguments));
    }

    public Object invoke(Signature function, ConnectorSession session, List<Object> arguments) {
        ScalarFunctionImplementation implementation = this.registry.getScalarFunctionImplementation(function);
        MethodHandle method = implementation.getMethodHandle();
        ArrayList<Object> actualArguments = new ArrayList<Object>(arguments.size() + 1);
        Iterator<Object> iterator = arguments.iterator();
        for (int i = 0; i < method.type().parameterCount(); ++i) {
            TypeDescriptor.OfField parameterType = method.type().parameterType(i);
            if (parameterType == ConnectorSession.class) {
                actualArguments.add(session);
                continue;
            }
            Preconditions.checkArgument((boolean)iterator.hasNext(), (String)"Not enough arguments provided for method: %s", (Object[])new Object[]{method.type()});
            Object argument = iterator.next();
            if (implementation.getNullFlags().get(i).booleanValue()) {
                boolean isNull;
                boolean bl = isNull = argument == null;
                if (isNull) {
                    argument = Defaults.defaultValue((Class)parameterType);
                }
                actualArguments.add(argument);
                actualArguments.add(isNull);
                ++i;
                continue;
            }
            actualArguments.add(argument);
        }
        Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0, (String)"Too many arguments provided for method: %s", (Object[])new Object[]{method.type()});
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }
}

