/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.discovery.EmbeddedDiscoveryModule;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.eventlistener.EventListenerModule;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.StaticCatalogStore;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.security.AccessControlModule;
import com.facebook.presto.server.GracefulShutdownModule;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PrestoSystemRequirements;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.ServerMainModule;
import com.facebook.presto.server.security.ServerSecurityModule;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.event.client.HttpEventModule;
import io.airlift.event.client.JsonEventModule;
import io.airlift.http.server.HttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.JmxHttpModule;
import io.airlift.jmx.JmxModule;
import io.airlift.json.JsonModule;
import io.airlift.log.LogJmxModule;
import io.airlift.log.Logger;
import io.airlift.node.NodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class PrestoServer
implements Runnable {
    private final SqlParserOptions sqlParserOptions;

    public static void main(String[] args) {
        new PrestoServer().run();
    }

    public PrestoServer() {
        this(new SqlParserOptions());
    }

    public PrestoServer(SqlParserOptions sqlParserOptions) {
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
    }

    @Override
    public void run() {
        PrestoSystemRequirements.verifyJvmRequirements();
        PrestoSystemRequirements.verifySystemTimeIsReasonable();
        Logger log = Logger.get(PrestoServer.class);
        ImmutableList.Builder modules = ImmutableList.builder();
        modules.add((Object[])new Module[]{new NodeModule(), new DiscoveryModule(), new HttpServerModule(), new JsonModule(), new JaxrsModule(true), new MBeanModule(), new JmxModule(), new JmxHttpModule(), new LogJmxModule(), new TraceTokenModule(), new JsonEventModule(), new HttpEventModule(), new EmbeddedDiscoveryModule(), new ServerSecurityModule(), new AccessControlModule(), new EventListenerModule(), new ServerMainModule(this.sqlParserOptions), new GracefulShutdownModule()});
        modules.addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        try {
            Injector injector = app.strictConfig().initialize();
            ((PluginManager)injector.getInstance(PluginManager.class)).loadPlugins();
            ((StaticCatalogStore)injector.getInstance(StaticCatalogStore.class)).loadCatalogs();
            PrestoServer.updateConnectorIds((Announcer)injector.getInstance(Announcer.class), (CatalogManager)injector.getInstance(CatalogManager.class), (ServerConfig)injector.getInstance(ServerConfig.class), (NodeSchedulerConfig)injector.getInstance(NodeSchedulerConfig.class));
            ((ResourceGroupManager)injector.getInstance(ResourceGroupManager.class)).loadConfigurationManager();
            ((AccessControlManager)injector.getInstance(AccessControlManager.class)).loadSystemAccessControl();
            ((EventListenerManager)injector.getInstance(EventListenerManager.class)).loadConfiguredEventListener();
            ((Announcer)injector.getInstance(Announcer.class)).start();
            log.info("======== SERVER STARTED ========");
        }
        catch (Throwable e) {
            log.error(e);
            System.exit(1);
        }
    }

    protected Iterable<? extends Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    private static void updateConnectorIds(Announcer announcer, CatalogManager metadata, ServerConfig serverConfig, NodeSchedulerConfig schedulerConfig) {
        ServiceAnnouncement announcement = PrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        String property = Strings.nullToEmpty((String)((String)announcement.getProperties().get("connectorIds")));
        List values = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property);
        LinkedHashSet connectorIds = new LinkedHashSet(values);
        if (connectorIds.isEmpty()) {
            List<Catalog> catalogs = metadata.getCatalogs();
            if (serverConfig.isCoordinator() && !schedulerConfig.isIncludeCoordinator()) {
                catalogs.stream().map(Catalog::getConnectorId).filter(connectorId -> connectorId.getCatalogName().equals("jmx")).map(Object::toString).forEach(connectorIds::add);
            } else {
                catalogs.stream().map(Catalog::getConnectorId).map(Object::toString).forEach(connectorIds::add);
            }
        }
        ServiceAnnouncement.ServiceAnnouncementBuilder builder = ServiceAnnouncement.serviceAnnouncement((String)announcement.getType());
        for (Map.Entry entry : announcement.getProperties().entrySet()) {
            if (((String)entry.getKey()).equals("connectorIds")) continue;
            builder.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        builder.addProperty("connectorIds", Joiner.on((char)',').join(connectorIds));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(builder.build());
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new IllegalArgumentException("Presto announcement not found: " + announcements);
    }
}

