/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.NodeState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/v1/cluster")
public class ClusterStatsResource {
    private final InternalNodeManager nodeManager;
    private final QueryManager queryManager;
    private final boolean isIncludeCoordinator;

    @Inject
    public ClusterStatsResource(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager, QueryManager queryManager) {
        this.isIncludeCoordinator = Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @GET
    @Produces(value={"application/json"})
    public ClusterStats getClusterStats() {
        long runningQueries = 0L;
        long blockedQueries = 0L;
        long queuedQueries = 0L;
        long activeNodes = this.nodeManager.getNodes(NodeState.ACTIVE).size();
        if (!this.isIncludeCoordinator) {
            --activeNodes;
        }
        long runningDrivers = 0L;
        double memoryReservation = 0.0;
        double rowInputRate = 0.0;
        double byteInputRate = 0.0;
        double cpuTimeRate = 0.0;
        for (QueryInfo query : this.queryManager.getAllQueryInfo()) {
            if (query.getState() == QueryState.QUEUED) {
                ++queuedQueries;
            } else if (query.getState() == QueryState.RUNNING) {
                if (query.getQueryStats().isFullyBlocked()) {
                    ++blockedQueries;
                } else {
                    ++runningQueries;
                }
            }
            if (query.getState().isDone()) continue;
            double totalExecutionTimeSeconds = query.getQueryStats().getElapsedTime().getValue(TimeUnit.SECONDS);
            if (totalExecutionTimeSeconds != 0.0) {
                byteInputRate += (double)query.getQueryStats().getProcessedInputDataSize().toBytes() / totalExecutionTimeSeconds;
                rowInputRate += (double)query.getQueryStats().getProcessedInputPositions() / totalExecutionTimeSeconds;
                cpuTimeRate += query.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS) / totalExecutionTimeSeconds;
            }
            memoryReservation += (double)query.getQueryStats().getTotalMemoryReservation().toBytes();
            runningDrivers += (long)query.getQueryStats().getRunningDrivers();
        }
        return new ClusterStats(runningQueries, blockedQueries, queuedQueries, activeNodes, runningDrivers, memoryReservation, rowInputRate, byteInputRate, cpuTimeRate);
    }

    public static class ClusterStats {
        private final long runningQueries;
        private final long blockedQueries;
        private final long queuedQueries;
        private final long activeWorkers;
        private final long runningDrivers;
        private final double reservedMemory;
        private final double rowInputRate;
        private final double byteInputRate;
        private final double cpuTimeRate;

        @JsonCreator
        public ClusterStats(@JsonProperty(value="runningQueries") long runningQueries, @JsonProperty(value="blockedQueries") long blockedQueries, @JsonProperty(value="queuedQueries") long queuedQueries, @JsonProperty(value="activeWorkers") long activeWorkers, @JsonProperty(value="runningDrivers") long runningDrivers, @JsonProperty(value="reservedMemory") double reservedMemory, @JsonProperty(value="rowInputRate") double rowInputRate, @JsonProperty(value="byteInputRate") double byteInputRate, @JsonProperty(value="cpuTimeRate") double cpuTimeRate) {
            this.runningQueries = runningQueries;
            this.blockedQueries = blockedQueries;
            this.queuedQueries = queuedQueries;
            this.activeWorkers = activeWorkers;
            this.runningDrivers = runningDrivers;
            this.reservedMemory = reservedMemory;
            this.rowInputRate = rowInputRate;
            this.byteInputRate = byteInputRate;
            this.cpuTimeRate = cpuTimeRate;
        }

        @JsonProperty
        public long getRunningQueries() {
            return this.runningQueries;
        }

        @JsonProperty
        public long getBlockedQueries() {
            return this.blockedQueries;
        }

        @JsonProperty
        public long getQueuedQueries() {
            return this.queuedQueries;
        }

        @JsonProperty
        public long getActiveWorkers() {
            return this.activeWorkers;
        }

        @JsonProperty
        public long getRunningDrivers() {
            return this.runningDrivers;
        }

        @JsonProperty
        public double getReservedMemory() {
            return this.reservedMemory;
        }

        @JsonProperty
        public double getRowInputRate() {
            return this.rowInputRate;
        }

        @JsonProperty
        public double getByteInputRate() {
            return this.byteInputRate;
        }

        @JsonProperty
        public double getCpuTimeRate() {
            return this.cpuTimeRate;
        }
    }
}

