/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import java.io.File;
import java.io.FileInputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AccessControlManager
implements AccessControl {
    private static final Logger log = Logger.get(AccessControlManager.class);
    private static final File ACCESS_CONTROL_CONFIGURATION = new File("etc/access-control.properties");
    private static final String ACCESS_CONTROL_PROPERTY_NAME = "access-control.name";
    public static final String ALLOW_ALL_ACCESS_CONTROL = "allow-all";
    private final TransactionManager transactionManager;
    private final Map<String, SystemAccessControlFactory> systemAccessControlFactories = new ConcurrentHashMap<String, SystemAccessControlFactory>();
    private final Map<ConnectorId, CatalogAccessControlEntry> connectorAccessControl = new ConcurrentHashMap<ConnectorId, CatalogAccessControlEntry>();
    private final AtomicReference<SystemAccessControl> systemAccessControl = new AtomicReference<InitializingSystemAccessControl>(new InitializingSystemAccessControl());
    private final AtomicBoolean systemAccessControlLoading = new AtomicBoolean();
    private final CounterStat authenticationSuccess = new CounterStat();
    private final CounterStat authenticationFail = new CounterStat();
    private final CounterStat authorizationSuccess = new CounterStat();
    private final CounterStat authorizationFail = new CounterStat();

    @Inject
    public AccessControlManager(TransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.systemAccessControlFactories.put(ALLOW_ALL_ACCESS_CONTROL, new SystemAccessControlFactory(){

            public String getName() {
                return AccessControlManager.ALLOW_ALL_ACCESS_CONTROL;
            }

            public SystemAccessControl create(Map<String, String> config) {
                Objects.requireNonNull(config, "config is null");
                Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"The none access-controller does not support any configuration properties");
                return new AllowAllSystemAccessControl();
            }
        });
    }

    public void addSystemAccessControlFactory(SystemAccessControlFactory accessControlFactory) {
        Objects.requireNonNull(accessControlFactory, "accessControlFactory is null");
        if (this.systemAccessControlFactories.putIfAbsent(accessControlFactory.getName(), accessControlFactory) != null) {
            throw new IllegalArgumentException(String.format("Access control '%s' is already registered", accessControlFactory.getName()));
        }
    }

    public void addCatalogAccessControl(ConnectorId connectorId, ConnectorAccessControl accessControl) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        Preconditions.checkState((this.connectorAccessControl.putIfAbsent(connectorId, new CatalogAccessControlEntry(connectorId, accessControl)) == null ? 1 : 0) != 0, (String)"Access control for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public void removeCatalogAccessControl(ConnectorId connectorId) {
        this.connectorAccessControl.remove(connectorId);
    }

    public void loadSystemAccessControl() throws Exception {
        if (ACCESS_CONTROL_CONFIGURATION.exists()) {
            HashMap<String, String> properties = new HashMap<String, String>(AccessControlManager.loadProperties(ACCESS_CONTROL_CONFIGURATION));
            String accessControlName = (String)properties.remove(ACCESS_CONTROL_PROPERTY_NAME);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessControlName) ? 1 : 0) != 0, (String)"Access control configuration %s does not contain %s", (Object[])new Object[]{ACCESS_CONTROL_CONFIGURATION.getAbsoluteFile(), ACCESS_CONTROL_PROPERTY_NAME});
            this.setSystemAccessControl(accessControlName, properties);
        } else {
            this.setSystemAccessControl(ALLOW_ALL_ACCESS_CONTROL, (Map<String, String>)ImmutableMap.of());
        }
    }

    @VisibleForTesting
    protected void setSystemAccessControl(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        Preconditions.checkState((boolean)this.systemAccessControlLoading.compareAndSet(false, true), (Object)"System access control already initialized");
        log.info("-- Loading system access control --");
        SystemAccessControlFactory systemAccessControlFactory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((systemAccessControlFactory != null ? 1 : 0) != 0, (String)"Access control %s is not registered", (Object[])new Object[]{name});
        SystemAccessControl systemAccessControl = systemAccessControlFactory.create((Map)ImmutableMap.copyOf(properties));
        this.systemAccessControl.set(systemAccessControl);
        log.info("-- Loaded system access control %s --", new Object[]{name});
    }

    @Override
    public void checkCanSetUser(Principal principal, String userName) {
        Objects.requireNonNull(userName, "userName is null");
        this.authenticationCheck(() -> this.systemAccessControl.get().checkCanSetUser(principal, userName));
    }

    @Override
    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateSchema(identity, schemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateSchema(entry.getTransactionHandle(transactionId), identity, schemaName.getSchemaName()));
        }
    }

    @Override
    public void checkCanDropSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropSchema(identity, schemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropSchema(entry.getTransactionHandle(transactionId), identity, schemaName.getSchemaName()));
        }
    }

    @Override
    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName, String newSchemaName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameSchema(identity, schemaName, newSchemaName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, schemaName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameSchema(entry.getTransactionHandle(transactionId), identity, schemaName.getSchemaName(), newSchemaName));
        }
    }

    @Override
    public void checkCanCreateTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRenameTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameTable(identity, tableName.asCatalogSchemaTableName(), newTableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName(), newTableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanAddColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanAddColumn(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanAddColumn(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRenameColumn(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRenameColumn(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSelectFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSelectFromTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSelectFromTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanInsertIntoTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanInsertIntoTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDeleteFromTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDeleteFromTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateView(identity, viewName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateView(entry.getTransactionHandle(transactionId), identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanDropView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanDropView(identity, viewName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanDropView(entry.getTransactionHandle(transactionId), identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSelectFromView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSelectFromView(identity, viewName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSelectFromView(entry.getTransactionHandle(transactionId), identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateViewWithSelectFromTable(identity, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateViewWithSelectFromTable(entry.getTransactionHandle(transactionId), identity, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanCreateViewWithSelectFromView(identity, viewName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, viewName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanCreateViewWithSelectFromView(entry.getTransactionHandle(transactionId), identity, viewName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanGrantTablePrivilege(TransactionId transactionId, Identity identity, Privilege privilege, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanGrantTablePrivilege(identity, privilege, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanGrantTablePrivilege(entry.getTransactionHandle(transactionId), identity, privilege, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanRevokeTablePrivilege(TransactionId transactionId, Identity identity, Privilege privilege, QualifiedObjectName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanRevokeTablePrivilege(identity, privilege, tableName.asCatalogSchemaTableName()));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, tableName.getCatalogName());
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanRevokeTablePrivilege(entry.getTransactionHandle(transactionId), identity, privilege, tableName.asSchemaTableName()));
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetSystemSessionProperty(identity, propertyName));
    }

    @Override
    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, String catalogName, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.authorizationCheck(() -> this.systemAccessControl.get().checkCanSetCatalogSessionProperty(identity, catalogName, propertyName));
        CatalogAccessControlEntry entry = this.getConnectorAccessControl(transactionId, catalogName);
        if (entry != null) {
            this.authorizationCheck(() -> entry.getAccessControl().checkCanSetCatalogSessionProperty(identity, propertyName));
        }
    }

    private CatalogAccessControlEntry getConnectorAccessControl(TransactionId transactionId, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(transactionId, catalogName).map(metadata -> this.connectorAccessControl.get(metadata.getConnectorId())).orElse(null);
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationSuccess() {
        return this.authenticationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthenticationFail() {
        return this.authenticationFail;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationSuccess() {
        return this.authorizationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationFail() {
        return this.authorizationFail;
    }

    private void authenticationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authenticationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authenticationFail.update(1L);
            throw e;
        }
    }

    private void authorizationCheck(Runnable runnable) {
        try {
            runnable.run();
            this.authorizationSuccess.update(1L);
        }
        catch (PrestoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private static Map<String, String> loadProperties(File file) throws Exception {
        Objects.requireNonNull(file, "file is null");
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        return Maps.fromProperties((Properties)properties);
    }

    private static class AllowAllSystemAccessControl
    implements SystemAccessControl {
        private AllowAllSystemAccessControl() {
        }

        public void checkCanSetUser(Principal principal, String userName) {
        }

        public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        }

        public void checkCanCreateSchema(Identity identity, CatalogSchemaName schema) {
        }

        public void checkCanDropSchema(Identity identity, CatalogSchemaName schema) {
        }

        public void checkCanRenameSchema(Identity identity, CatalogSchemaName schema, String newSchemaName) {
        }

        public void checkCanCreateTable(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanDropTable(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanRenameTable(Identity identity, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        }

        public void checkCanAddColumn(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanRenameColumn(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanSelectFromTable(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanInsertIntoTable(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanDeleteFromTable(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanCreateView(Identity identity, CatalogSchemaTableName view) {
        }

        public void checkCanDropView(Identity identity, CatalogSchemaTableName view) {
        }

        public void checkCanSelectFromView(Identity identity, CatalogSchemaTableName view) {
        }

        public void checkCanCreateViewWithSelectFromTable(Identity identity, CatalogSchemaTableName table) {
        }

        public void checkCanCreateViewWithSelectFromView(Identity identity, CatalogSchemaTableName view) {
        }

        public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        }

        public void checkCanGrantTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table) {
        }

        public void checkCanRevokeTablePrivilege(Identity identity, Privilege privilege, CatalogSchemaTableName table) {
        }
    }

    private static class InitializingSystemAccessControl
    implements SystemAccessControl {
        private InitializingSystemAccessControl() {
        }

        public void checkCanSetUser(Principal principal, String userName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }

        public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Presto server is still initializing");
        }
    }

    private class CatalogAccessControlEntry {
        private final ConnectorId connectorId;
        private final ConnectorAccessControl accessControl;

        public CatalogAccessControlEntry(ConnectorId connectorId, ConnectorAccessControl accessControl) {
            this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        }

        public ConnectorId getConnectorId() {
            return this.connectorId;
        }

        public ConnectorAccessControl getAccessControl() {
            return this.accessControl;
        }

        public ConnectorTransactionHandle getTransactionHandle(TransactionId transactionId) {
            return AccessControlManager.this.transactionManager.getConnectorTransaction(transactionId, this.connectorId);
        }
    }
}

