/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MapFilterFunction
extends SqlScalarFunction {
    public static final MapFilterFunction MAP_FILTER_FUNCTION = new MapFilterFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapFilterFunction.class, "filter", Type.class, Type.class, Block.class, MethodHandle.class);

    private MapFilterFunction() {
        super(new Signature("map_filter", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K,V)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)"), (Object)TypeSignature.parseTypeSignature((String)"function(K,V,boolean)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "return map containing entries that match the given predicate";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(keyType).bindTo(valueType), this.isDeterministic());
    }

    public static Block filter(Type keyType, Type valueType, Block block, MethodHandle function) {
        int positionCount = block.getPositionCount();
        InterleavedBlockBuilder resultBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)valueType), new BlockBuilderStatus(), positionCount);
        for (int position = 0; position < positionCount; position += 2) {
            Boolean keep;
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)block, (int)position);
            Object value = TypeUtils.readNativeValue((Type)valueType, (Block)block, (int)(position + 1));
            try {
                keep = function.invoke(key, value);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (!Boolean.TRUE.equals(keep)) continue;
            keyType.appendTo(block, position, (BlockBuilder)resultBuilder);
            valueType.appendTo(block, position + 1, (BlockBuilder)resultBuilder);
        }
        return resultBuilder.build();
    }
}

