/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.TypedKeyValueHeap;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.MinMaxByNState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;

public class MinMaxByNStateFactory
implements AccumulatorStateFactory<MinMaxByNState> {
    public MinMaxByNState createSingleState() {
        return new SingleMinMaxByNState();
    }

    public Class<? extends MinMaxByNState> getSingleStateClass() {
        return SingleMinMaxByNState.class;
    }

    public MinMaxByNState createGroupedState() {
        return new GroupedMinMaxByNState();
    }

    public Class<? extends MinMaxByNState> getGroupedStateClass() {
        return GroupedMinMaxByNState.class;
    }

    public static class SingleMinMaxByNState
    implements MinMaxByNState {
        private TypedKeyValueHeap typedKeyValueHeap;

        public long getEstimatedSize() {
            if (this.typedKeyValueHeap == null) {
                return 0L;
            }
            return this.typedKeyValueHeap.getEstimatedSize();
        }

        @Override
        public TypedKeyValueHeap getTypedKeyValueHeap() {
            return this.typedKeyValueHeap;
        }

        @Override
        public void setTypedKeyValueHeap(TypedKeyValueHeap typedKeyValueHeap) {
            this.typedKeyValueHeap = typedKeyValueHeap;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedMinMaxByNState
    extends AbstractGroupedAccumulatorState
    implements MinMaxByNState {
        private final ObjectBigArray<TypedKeyValueHeap> heaps = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return this.heaps.sizeOf() + this.size;
        }

        @Override
        public TypedKeyValueHeap getTypedKeyValueHeap() {
            return (TypedKeyValueHeap)this.heaps.get(this.getGroupId());
        }

        @Override
        public void setTypedKeyValueHeap(TypedKeyValueHeap value) {
            TypedKeyValueHeap previous = this.getTypedKeyValueHeap();
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.heaps.set(this.getGroupId(), (Object)value);
            this.size += value.getEstimatedSize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }
    }
}

