/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.BigIntegerState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import io.airlift.slice.Slices;
import java.math.BigInteger;

public class BigIntegerStateSerializer
implements AccumulatorStateSerializer<BigIntegerState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(BigIntegerState state, BlockBuilder out) {
        if (state.getBigInteger() == null) {
            out.appendNull();
        } else {
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedBuffer((byte[])state.getBigInteger().toByteArray()));
        }
    }

    public void deserialize(Block block, int index, BigIntegerState state) {
        if (!block.isNull(index)) {
            state.setBigInteger(new BigInteger(VarbinaryType.VARBINARY.getSlice(block, index).getBytes()));
        }
    }
}

