/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.RealType;

@AggregationFunction(value="sum")
public final class RealSumAggregation {
    private RealSumAggregation() {
    }

    @InputFunction
    public static void sum(NullableDoubleState state, @SqlType(value="real") long value) {
        state.setNull(false);
        state.setDouble(state.getDouble() + (double)Float.intBitsToFloat((int)value));
    }

    @CombineFunction
    public static void combine(NullableDoubleState state, NullableDoubleState otherState) {
        if (state.isNull()) {
            if (otherState.isNull()) {
                return;
            }
            state.setNull(false);
            state.setDouble(otherState.getDouble());
            return;
        }
        if (!otherState.isNull()) {
            state.setDouble(state.getDouble() + otherState.getDouble());
        }
    }

    @OutputFunction(value="real")
    public static void output(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)state.getDouble()));
        }
    }
}

