/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.DoubleRegressionAggregation;
import com.facebook.presto.operator.aggregation.state.RegressionState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.RealType;

@AggregationFunction
public class RealRegressionAggregation {
    private RealRegressionAggregation() {
    }

    @InputFunction
    public static void input(RegressionState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleRegressionAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(RegressionState state, RegressionState otherState) {
        DoubleRegressionAggregation.combine(state, otherState);
    }

    @AggregationFunction(value="regr_slope")
    @OutputFunction(value="real")
    public static void regrSlope(RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionSlope(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }

    @AggregationFunction(value="regr_intercept")
    @OutputFunction(value="real")
    public static void regrIntercept(RegressionState state, BlockBuilder out) {
        double result = AggregationUtils.getRegressionIntercept(state);
        if (Double.isFinite(result)) {
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)result));
        } else {
            out.appendNull();
        }
    }
}

