/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.LongState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BigintType;

@AggregationFunction(value="count_if")
public final class CountIfAggregation {
    private CountIfAggregation() {
    }

    @InputFunction
    public static void input(LongState state, @SqlType(value="boolean") boolean value) {
        if (value) {
            state.setLong(state.getLong() + 1L);
        }
    }

    @CombineFunction
    public static void combine(LongState state, LongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
    }

    @OutputFunction(value="bigint")
    public static void output(LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getLong());
    }
}

