/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public abstract class AbstractMinMaxBy
extends SqlAggregationFunction {
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxBy.class, "output", Type.class, MaxOrMinByState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxBy.class, "input", Boolean.TYPE, Type.class, MaxOrMinByState.class, Block.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxBy.class, "combine", Boolean.TYPE, Type.class, MaxOrMinByState.class, MaxOrMinByState.class);
    private final boolean min;

    protected AbstractMinMaxBy(boolean min) {
        super((min ? "min" : "max") + "_by", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"V"), (Object)TypeSignature.parseTypeSignature((String)"K")));
        this.min = min;
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        return this.generateAggregation(valueType, keyType);
    }

    private InternalAggregationFunction generateAggregation(Type valueType, Type keyType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(this.getClass().getClassLoader());
        MaxOrMinByStateSerializer stateSerializer = new MaxOrMinByStateSerializer(valueType, keyType);
        Type intermediateType = stateSerializer.getSerializedType();
        ImmutableList inputTypes = ImmutableList.of((Object)valueType, (Object)keyType);
        MaxOrMinByStateFactory stateFactory = new MaxOrMinByStateFactory();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.getSignature().getName(), valueType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList())), AbstractMinMaxBy.createInputParameterMetadata(valueType, keyType), MethodHandles.insertArguments(INPUT_FUNCTION, 0, this.min).bindTo(keyType), MethodHandles.insertArguments(COMBINE_FUNCTION, 0, this.min).bindTo(keyType), OUTPUT_FUNCTION.bindTo(valueType), MaxOrMinByState.class, stateSerializer, stateFactory, valueType);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(this.getSignature().getName(), (List<Type>)inputTypes, intermediateType, valueType, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value, Type key) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, key), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(boolean min, Type keyType, MaxOrMinByState state, Block value, Block key, int position) {
        if (state.getKey() == null || state.getKey().isNull(0) || AbstractMinMaxBy.compare(keyType.compareTo(key, position, state.getKey(), 0), min)) {
            state.setKey(key.getSingleValueBlock(position));
            state.setValue(value.getSingleValueBlock(position));
        }
    }

    public static void combine(boolean min, Type keyType, MaxOrMinByState state, MaxOrMinByState otherState) {
        Block key = state.getKey();
        Block otherKey = otherState.getKey();
        if (key == null || otherKey != null && AbstractMinMaxBy.compare(keyType.compareTo(otherKey, 0, key, 0), min)) {
            state.setKey(otherKey);
            state.setValue(otherState.getValue());
        }
    }

    public static void output(Type valueType, MaxOrMinByState state, BlockBuilder out) {
        if (state.getValue() == null) {
            out.appendNull();
        } else {
            valueType.appendTo(state.getValue(), 0, out);
        }
    }

    private static boolean compare(int value, boolean lessThan) {
        return lessThan ? value < 0 : value > 0;
    }
}

