/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TaskOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final OutputBuffer outputBuffer;
    private final Function<Page, Page> pagePreprocessor;
    private final PagesSerde serde;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private boolean finished;

    public TaskOutputOperator(OperatorContext operatorContext, OutputBuffer outputBuffer, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.serde = Objects.requireNonNull(serdeFactory, "serdeFactory is null").createPagesSerde();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return !this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        Preconditions.checkState((this.blocked == NOT_BLOCKED ? 1 : 0) != 0, (Object)"output is already blocked");
        page = this.pagePreprocessor.apply(page);
        List serializedPages = (List)PageSplitterUtil.splitPage(page, 0x100000L).stream().map(this.serde::serialize).collect(ImmutableCollectors.toImmutableList());
        ListenableFuture<?> future = this.outputBuffer.enqueue(serializedPages);
        if (!future.isDone()) {
            this.blocked = future;
        }
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class TaskOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final OutputBuffer outputBuffer;
        private final Function<Page, Page> pagePreprocessor;
        private final PagesSerdeFactory serdeFactory;

        public TaskOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, OutputBuffer outputBuffer, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TaskOutputOperator.class.getSimpleName());
            return new TaskOutputOperator(operatorContext, this.outputBuffer, this.pagePreprocessor, this.serdeFactory);
        }

        @Override
        public void close() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new TaskOutputOperatorFactory(this.operatorId, this.planNodeId, this.outputBuffer, this.pagePreprocessor, this.serdeFactory);
        }
    }

    public static class TaskOutputFactory
    implements OutputFactory {
        private final OutputBuffer outputBuffer;

        public TaskOutputFactory(OutputBuffer outputBuffer) {
            this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, PagesSerdeFactory serdeFactory) {
            return new TaskOutputOperatorFactory(operatorId, planNodeId, this.outputBuffer, pagePreprocessor, serdeFactory);
        }
    }
}

