/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionedLookupSourceFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final PartitionedLookupSourceFactory lookupSourceFactory;
    private final int partitionIndex;
    private final List<Integer> outputChannels;
    private final List<Integer> hashChannels;
    private final Optional<Integer> preComputedHashChannel;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final PagesIndex index;
    private boolean finishing;
    private final HashCollisionsCounter hashCollisionsCounter;

    public HashBuilderOperator(OperatorContext operatorContext, PartitionedLookupSourceFactory lookupSourceFactory, int partitionIndex, List<Integer> outputChannels, List<Integer> hashChannels, Optional<Integer> preComputedHashChannel, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, int expectedPositions) {
        this.operatorContext = operatorContext;
        this.partitionIndex = partitionIndex;
        this.filterFunctionFactory = filterFunctionFactory;
        this.index = new PagesIndex(lookupSourceFactory.getTypes(), expectedPositions);
        this.lookupSourceFactory = lookupSourceFactory;
        this.outputChannels = outputChannels;
        this.hashChannels = hashChannels;
        this.preComputedHashChannel = preComputedHashChannel;
        this.hashCollisionsCounter = new HashCollisionsCounter(operatorContext);
        operatorContext.setInfoSupplier(this.hashCollisionsCounter);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.lookupSourceFactory.getTypes();
    }

    @Override
    public void finish() {
        if (this.finishing) {
            return;
        }
        this.finishing = true;
        LookupSourceSupplier partition = this.index.createLookupSourceSupplier(this.operatorContext.getSession(), this.hashChannels, this.preComputedHashChannel, this.filterFunctionFactory, Optional.of(this.outputChannels));
        this.lookupSourceFactory.setPartitionLookupSourceSupplier(this.partitionIndex, partition);
        this.operatorContext.setMemoryReservation(((LookupSource)partition.get()).getInMemorySizeInBytes());
        this.hashCollisionsCounter.recordHashCollision(partition.getHashCollisions(), partition.getExpectedHashCollisions());
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.lookupSourceFactory.isDestroyed().isDone();
    }

    @Override
    public boolean needsInput() {
        return !this.finishing;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.finishing) {
            return NOT_BLOCKED;
        }
        return MoreFutures.toListenableFuture(this.lookupSourceFactory.isDestroyed());
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.index.addPage(page);
        if (!this.operatorContext.trySetMemoryReservation(this.index.getEstimatedSize().toBytes())) {
            this.index.compact();
        }
        this.operatorContext.setMemoryReservation(this.index.getEstimatedSize().toBytes());
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PartitionedLookupSourceFactory lookupSourceFactory;
        private final List<Integer> outputChannels;
        private final List<Integer> hashChannels;
        private final Optional<Integer> preComputedHashChannel;
        private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
        private final int expectedPositions;
        private int partitionIndex;
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, Map<Symbol, Integer> layout, List<Integer> hashChannels, Optional<Integer> preComputedHashChannel, boolean outer, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, int expectedPositions, int partitionCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
            this.lookupSourceFactory = new PartitionedLookupSourceFactory(types, (List)outputChannels.stream().map(types::get).collect(ImmutableCollectors.toImmutableList()), hashChannels, partitionCount, Objects.requireNonNull(layout, "layout is null"), outer);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
            this.preComputedHashChannel = Objects.requireNonNull(preComputedHashChannel, "preComputedHashChannel is null");
            this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
            this.expectedPositions = expectedPositions;
        }

        public LookupSourceFactory getLookupSourceFactory() {
            return this.lookupSourceFactory;
        }

        @Override
        public List<Type> getTypes() {
            return this.lookupSourceFactory.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashBuilderOperator.class.getSimpleName());
            HashBuilderOperator operator = new HashBuilderOperator(operatorContext, this.lookupSourceFactory, this.partitionIndex, this.outputChannels, this.hashChannels, this.preComputedHashChannel, this.filterFunctionFactory, this.expectedPositions);
            ++this.partitionIndex;
            return operator;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Parallel hash build can not be duplicated");
        }
    }
}

