/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunctionBuilder;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class PolymorphicScalarFunction
extends SqlScalarFunction {
    private final String description;
    private final boolean hidden;
    private final boolean deterministic;
    private final boolean nullableResult;
    private final List<Boolean> nullableArguments;
    private final List<Boolean> nullFlags;
    private final List<SqlScalarFunctionBuilder.MethodsGroup> methodsGroups;

    PolymorphicScalarFunction(Signature signature, String description, boolean hidden, boolean deterministic, boolean nullableResult, List<Boolean> nullableArguments, List<Boolean> nullFlags, List<SqlScalarFunctionBuilder.MethodsGroup> methodsGroups) {
        super(signature);
        this.description = description;
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.nullableResult = nullableResult;
        this.nullableArguments = Objects.requireNonNull(nullableArguments, "nullableArguments is null");
        this.nullFlags = Objects.requireNonNull(nullFlags, "nullFlags is null");
        this.methodsGroups = Objects.requireNonNull(methodsGroups, "methodsWithExtraParametersFunctions is null");
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        List<TypeSignature> resolvedParameterTypeSignatures = SignatureBinder.applyBoundVariables(this.getSignature().getArgumentTypes(), boundVariables);
        List<Type> resolvedParameterTypes = TypeUtils.resolveTypes(resolvedParameterTypeSignatures, typeManager);
        TypeSignature resolvedReturnTypeSignature = SignatureBinder.applyBoundVariables(this.getSignature().getReturnType(), boundVariables);
        Type resolvedReturnType = typeManager.getType(resolvedReturnTypeSignature);
        SqlScalarFunctionBuilder.SpecializeContext context = new SqlScalarFunctionBuilder.SpecializeContext(boundVariables, resolvedParameterTypes, resolvedReturnType, typeManager, functionRegistry);
        Optional<Object> matchingMethod = Optional.empty();
        Optional<Object> matchingMethodsGroup = Optional.empty();
        for (SqlScalarFunctionBuilder.MethodsGroup candidateMethodsGroup : this.methodsGroups) {
            for (Method candidateMethod : candidateMethodsGroup.getMethods()) {
                if (!this.matchesParameterAndReturnTypes(candidateMethod, resolvedParameterTypes, resolvedReturnType) || !PolymorphicScalarFunction.predicateIsTrue(candidateMethodsGroup, context)) continue;
                if (matchingMethod.isPresent()) {
                    if (PolymorphicScalarFunction.onlyFirstMatchedMethodHasPredicate((SqlScalarFunctionBuilder.MethodsGroup)matchingMethodsGroup.get(), candidateMethodsGroup)) continue;
                    throw new IllegalStateException("two matching methods (" + ((Method)matchingMethod.get()).getName() + " and " + candidateMethod.getName() + ") for parameter types " + resolvedParameterTypeSignatures);
                }
                matchingMethod = Optional.of(candidateMethod);
                matchingMethodsGroup = Optional.of(candidateMethodsGroup);
            }
        }
        Preconditions.checkState((boolean)matchingMethod.isPresent(), (String)"no matching method for parameter types %s", (Object[])new Object[]{resolvedParameterTypes});
        List<Object> extraParameters = PolymorphicScalarFunction.computeExtraParameters((SqlScalarFunctionBuilder.MethodsGroup)matchingMethodsGroup.get(), context);
        MethodHandle matchingMethodHandle = this.applyExtraParameters((Method)matchingMethod.get(), extraParameters);
        return new ScalarFunctionImplementation(this.nullableResult, this.nullableArguments, this.nullFlags, matchingMethodHandle, this.deterministic);
    }

    private boolean matchesParameterAndReturnTypes(Method method, List<Type> resolvedTypes, Type returnType) {
        Preconditions.checkState((method.getParameterCount() >= resolvedTypes.size() ? 1 : 0) != 0, (String)"method %s has not enough arguments: %s (should have at least %s)", (Object[])new Object[]{method.getName(), method.getParameterCount(), resolvedTypes.size()});
        Class<?>[] methodParameterJavaTypes = method.getParameterTypes();
        int methodParameterIndex = 0;
        for (int i = 0; i < resolvedTypes.size(); ++i) {
            Class<?> type = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), this.nullableArguments.get(i) != false && this.nullFlags.get(i) == false);
            if (!methodParameterJavaTypes[methodParameterIndex].equals(type)) {
                return false;
            }
            methodParameterIndex += this.nullFlags.get(i) != false ? 2 : 1;
        }
        return method.getReturnType().equals(PolymorphicScalarFunction.getNullAwareContainerType(returnType.getJavaType(), this.nullableResult));
    }

    private static boolean onlyFirstMatchedMethodHasPredicate(SqlScalarFunctionBuilder.MethodsGroup matchingMethodsGroup, SqlScalarFunctionBuilder.MethodsGroup methodsGroup) {
        return matchingMethodsGroup.getPredicate().isPresent() && !methodsGroup.getPredicate().isPresent();
    }

    private static boolean predicateIsTrue(SqlScalarFunctionBuilder.MethodsGroup methodsGroup, SqlScalarFunctionBuilder.SpecializeContext context) {
        return methodsGroup.getPredicate().map(predicate -> predicate.test(context)).orElse(true);
    }

    private static List<Object> computeExtraParameters(SqlScalarFunctionBuilder.MethodsGroup methodsGroup, SqlScalarFunctionBuilder.SpecializeContext context) {
        return methodsGroup.getExtraParametersFunction().map(function -> (List)function.apply(context)).orElse(Collections.emptyList());
    }

    private int getNullFlagsCount() {
        int count = 0;
        for (boolean flag : this.nullFlags) {
            if (!flag) continue;
            ++count;
        }
        return count;
    }

    private MethodHandle applyExtraParameters(Method matchingMethod, List<Object> extraParameters) {
        Signature signature = this.getSignature();
        int expectedArgumentsCount = signature.getArgumentTypes().size() + this.getNullFlagsCount() + extraParameters.size();
        int matchingMethodArgumentCount = matchingMethod.getParameterCount();
        Preconditions.checkState((matchingMethodArgumentCount == expectedArgumentsCount ? 1 : 0) != 0, (String)"method %s has invalid number of arguments: %s (should have %s)", (Object[])new Object[]{matchingMethod.getName(), matchingMethodArgumentCount, expectedArgumentsCount});
        MethodHandle matchingMethodHandle = Reflection.methodHandle(matchingMethod);
        matchingMethodHandle = MethodHandles.insertArguments(matchingMethodHandle, matchingMethodArgumentCount - extraParameters.size(), extraParameters.toArray());
        return matchingMethodHandle;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        Preconditions.checkArgument((clazz != Void.TYPE ? 1 : 0) != 0);
        return clazz;
    }
}

