/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.PageBufferInfo;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ClientBuffer {
    private final String taskInstanceId;
    private final OutputBuffers.OutputBufferId bufferId;
    private final AtomicLong rowsAdded = new AtomicLong();
    private final AtomicLong pagesAdded = new AtomicLong();
    private final AtomicLong bufferedBytes = new AtomicLong();
    @GuardedBy(value="this")
    private final AtomicLong currentSequenceId = new AtomicLong();
    @GuardedBy(value="this")
    private final LinkedList<SerializedPageReference> pages = new LinkedList();
    @GuardedBy(value="this")
    private boolean noMorePages;
    @GuardedBy(value="this")
    private final AtomicBoolean destroyed = new AtomicBoolean();
    @GuardedBy(value="this")
    private PendingRead pendingRead;

    public ClientBuffer(String taskInstanceId, OutputBuffers.OutputBufferId bufferId) {
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
    }

    public BufferInfo getInfo() {
        boolean destroyed = this.destroyed.get();
        long sequenceId = this.currentSequenceId.get();
        int bufferedPages = destroyed ? 0 : Math.max(Math.toIntExact(this.pagesAdded.get() - sequenceId), 0);
        PageBufferInfo pageBufferInfo = new PageBufferInfo(this.bufferId.getId(), bufferedPages, this.bufferedBytes.get(), this.rowsAdded.get(), this.pagesAdded.get());
        return new BufferInfo(this.bufferId, destroyed, bufferedPages, sequenceId, pageBufferInfo);
    }

    public boolean isDestroyed() {
        boolean destroyed = this.destroyed.get();
        return destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PendingRead pendingRead;
        ImmutableList removedPages;
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            removedPages = ImmutableList.copyOf(this.pages);
            this.pages.clear();
            this.bufferedBytes.getAndSet(0L);
            this.noMorePages = true;
            this.destroyed.set(true);
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        removedPages.forEach(SerializedPageReference::dereferencePage);
        if (pendingRead != null) {
            pendingRead.completeResultFutureWithEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueuePages(Collection<SerializedPageReference> pages) {
        PendingRead pendingRead;
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            if (this.noMorePages) {
                return;
            }
            pages.forEach(SerializedPageReference::addReference);
            this.pages.addAll(pages);
            long rowCount = pages.stream().mapToLong(SerializedPageReference::getPositionCount).sum();
            this.rowsAdded.addAndGet(rowCount);
            this.pagesAdded.addAndGet(pages.size());
            long bytesAdded = pages.stream().mapToLong(SerializedPageReference::getRetainedSizeInBytes).sum();
            this.bufferedBytes.addAndGet(bytesAdded);
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        if (pendingRead != null) {
            this.processRead(pendingRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CompletableFuture<BufferResult> getPages(long sequenceId, DataSize maxSize) {
        CompletableFuture<BufferResult> completableFuture;
        Preconditions.checkArgument((sequenceId >= 0L ? 1 : 0) != 0, (Object)"Invalid sequence id");
        this.acknowledgePages(sequenceId);
        PendingRead oldPendingRead = null;
        try {
            ClientBuffer clientBuffer = this;
            // MONITORENTER : clientBuffer
            oldPendingRead = this.pendingRead;
            this.pendingRead = null;
            if (!this.pages.isEmpty() || this.noMorePages || sequenceId != this.currentSequenceId.get()) {
                CompletableFuture<BufferResult> completableFuture2 = CompletableFuture.completedFuture(this.processRead(sequenceId, maxSize));
                // MONITOREXIT : clientBuffer
                if (oldPendingRead == null) return completableFuture2;
                oldPendingRead.completeResultFutureWithEmpty();
                return completableFuture2;
            }
            this.pendingRead = new PendingRead(this.taskInstanceId, sequenceId, maxSize);
            completableFuture = this.pendingRead.getResultFuture();
        }
        catch (Throwable throwable) {
            if (oldPendingRead == null) throw throwable;
            oldPendingRead.completeResultFutureWithEmpty();
            throw throwable;
        }
        if (oldPendingRead == null) return completableFuture;
        oldPendingRead.completeResultFutureWithEmpty();
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoMorePages() {
        PendingRead pendingRead;
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            if (this.noMorePages) {
                return;
            }
            this.noMorePages = true;
            pendingRead = this.pendingRead;
            this.pendingRead = null;
        }
        if (pendingRead != null) {
            this.processRead(pendingRead);
        }
    }

    private void processRead(PendingRead pendingRead) {
        if (pendingRead.getResultFuture().isDone()) {
            return;
        }
        BufferResult bufferResult = this.processRead(pendingRead.getSequenceId(), pendingRead.getMaxSize());
        pendingRead.getResultFuture().complete(bufferResult);
    }

    private synchronized BufferResult processRead(long sequenceId, DataSize maxSize) {
        if (sequenceId < this.currentSequenceId.get()) {
            return BufferResult.emptyResults(this.taskInstanceId, sequenceId, false);
        }
        if (this.pages.isEmpty() && this.noMorePages) {
            return BufferResult.emptyResults(this.taskInstanceId, this.currentSequenceId.get(), true);
        }
        Verify.verify((sequenceId == this.currentSequenceId.get() ? 1 : 0) != 0, (String)"Invalid sequence id", (Object[])new Object[0]);
        long maxBytes = maxSize.toBytes();
        ArrayList<SerializedPage> result = new ArrayList<SerializedPage>();
        long bytes = 0L;
        for (SerializedPageReference page : this.pages) {
            if (!result.isEmpty() && (bytes += page.getRetainedSizeInBytes()) > maxBytes) break;
            result.add(page.getSerializedPage());
        }
        return new BufferResult(this.taskInstanceId, sequenceId, sequenceId + (long)result.size(), false, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledgePages(long sequenceId) {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not acknowledge pages while holding a lock on this");
        ArrayList<SerializedPageReference> removedPages = new ArrayList<SerializedPageReference>();
        ClientBuffer clientBuffer = this;
        synchronized (clientBuffer) {
            if (this.destroyed.get()) {
                return;
            }
            long oldCurrentSequenceId = this.currentSequenceId.get();
            if (sequenceId < oldCurrentSequenceId) {
                return;
            }
            int pagesToRemove = Math.toIntExact(sequenceId - oldCurrentSequenceId);
            Preconditions.checkArgument((pagesToRemove <= this.pages.size() ? 1 : 0) != 0, (Object)"Invalid sequence id");
            long bytesRemoved = 0L;
            for (int i = 0; i < pagesToRemove; ++i) {
                SerializedPageReference removedPage = this.pages.removeFirst();
                removedPages.add(removedPage);
                bytesRemoved += removedPage.getRetainedSizeInBytes();
            }
            Verify.verify((boolean)this.currentSequenceId.compareAndSet(oldCurrentSequenceId, oldCurrentSequenceId + (long)pagesToRemove));
            Verify.verify((this.bufferedBytes.addAndGet(-bytesRemoved) >= 0L ? 1 : 0) != 0);
        }
        removedPages.forEach(SerializedPageReference::dereferencePage);
    }

    public String toString() {
        long sequenceId = this.currentSequenceId.get();
        boolean destroyed = this.destroyed.get();
        return MoreObjects.toStringHelper((Object)this).add("bufferId", (Object)this.bufferId).add("sequenceId", sequenceId).add("destroyed", destroyed).toString();
    }

    @ThreadSafe
    static class SerializedPageReference {
        private final SerializedPage serializedPage;
        private final AtomicInteger referenceCount;
        private final Runnable onDereference;

        public SerializedPageReference(SerializedPage serializedPage, int referenceCount, Runnable onDereference) {
            this.serializedPage = Objects.requireNonNull(serializedPage, "page is null");
            Preconditions.checkArgument((referenceCount > 0 ? 1 : 0) != 0, (Object)"referenceCount must be at least 1");
            this.referenceCount = new AtomicInteger(referenceCount);
            this.onDereference = Objects.requireNonNull(onDereference, "onDereference is null");
        }

        public void addReference() {
            int oldReferences = this.referenceCount.getAndIncrement();
            Preconditions.checkState((oldReferences > 0 ? 1 : 0) != 0, (Object)"Page has already been dereferenced");
        }

        public SerializedPage getSerializedPage() {
            return this.serializedPage;
        }

        public int getPositionCount() {
            return this.serializedPage.getPositionCount();
        }

        public long getRetainedSizeInBytes() {
            return this.serializedPage.getRetainedSizeInBytes();
        }

        public void dereferencePage() {
            int remainingReferences = this.referenceCount.decrementAndGet();
            Preconditions.checkState((remainingReferences >= 0 ? 1 : 0) != 0, (Object)"Page reference count is negative");
            if (remainingReferences == 0) {
                this.onDereference.run();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("referenceCount", (Object)this.referenceCount).toString();
        }
    }

    @Immutable
    private static class PendingRead {
        private final String taskInstanceId;
        private final long sequenceId;
        private final DataSize maxSize;
        private final CompletableFuture<BufferResult> resultFuture = new CompletableFuture();

        private PendingRead(String taskInstanceId, long sequenceId, DataSize maxSize) {
            this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
            this.sequenceId = sequenceId;
            this.maxSize = maxSize;
        }

        public long getSequenceId() {
            return this.sequenceId;
        }

        public DataSize getMaxSize() {
            return this.maxSize;
        }

        public CompletableFuture<BufferResult> getResultFuture() {
            return this.resultFuture;
        }

        public void completeResultFutureWithEmpty() {
            this.resultFuture.complete(BufferResult.emptyResults(this.taskInstanceId, this.sequenceId, false));
        }
    }
}

