/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system.jdbc;

import com.facebook.presto.Session;
import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.connector.system.jdbc.FilterUtil;
import com.facebook.presto.connector.system.jdbc.JdbcTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Types;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class TableJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "tables");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("table_type", (Type)VarcharType.createUnboundedVarcharType()).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("type_cat", (Type)VarcharType.createUnboundedVarcharType()).column("type_schem", (Type)VarcharType.createUnboundedVarcharType()).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("self_referencing_col_name", (Type)VarcharType.createUnboundedVarcharType()).column("ref_generation", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;

    @Inject
    public TableJdbcTable(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata);
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        GlobalSystemTransactionHandle transaction = Types.checkType(transactionHandle, GlobalSystemTransactionHandle.class, "transaction");
        Session session = FilterUtil.toSession(transaction.getTransactionId(), connectorSession);
        Optional<String> catalogFilter = FilterUtil.stringFilter(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.stringFilter(constraint, 1);
        Optional<String> tableFilter = FilterUtil.stringFilter(constraint, 2);
        Optional<String> typeFilter = FilterUtil.stringFilter(constraint, 3);
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (String catalog : FilterUtil.filter(this.metadata.getCatalogNames(session).keySet(), catalogFilter)) {
            QualifiedTablePrefix prefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
            if (FilterUtil.emptyOrEquals(typeFilter, "TABLE")) {
                for (QualifiedObjectName name : this.metadata.listTables(session, prefix)) {
                    table.addRow(TableJdbcTable.tableRow(name, "TABLE"));
                }
            }
            if (!FilterUtil.emptyOrEquals(typeFilter, "VIEW")) continue;
            for (QualifiedObjectName name : this.metadata.listViews(session, prefix)) {
                table.addRow(TableJdbcTable.tableRow(name, "VIEW"));
            }
        }
        return table.build().cursor();
    }

    private static Object[] tableRow(QualifiedObjectName name, String type) {
        return new Object[]{name.getCatalogName(), name.getSchemaName(), name.getObjectName(), type, null, null, null, null, null, null};
    }
}

