/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SetOperationNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PruneUnreferencedOutputs
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan, ImmutableSet.of());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Set<Symbol>> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            return context.defaultRewrite(node, (Set<Symbol>)ImmutableSet.copyOf(node.getSource().getOutputSymbols()));
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            HashSet expectedOutputSymbols = Sets.newHashSet((Iterable)context.get());
            node.getPartitioningScheme().getHashColumn().ifPresent(expectedOutputSymbols::add);
            node.getPartitioningScheme().getPartitioning().getColumns().stream().forEach(expectedOutputSymbols::add);
            ArrayList<List<Symbol>> inputsBySource = new ArrayList<List<Symbol>>(node.getInputs().size());
            for (int i = 0; i < node.getInputs().size(); ++i) {
                inputsBySource.add(new ArrayList());
            }
            ArrayList<Symbol> newOutputSymbols = new ArrayList<Symbol>(node.getOutputSymbols().size());
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol outputSymbol = node.getOutputSymbols().get(i);
                if (!expectedOutputSymbols.contains(outputSymbol)) continue;
                newOutputSymbols.add(outputSymbol);
                for (int source = 0; source < node.getInputs().size(); ++source) {
                    ((List)inputsBySource.get(source)).add(node.getInputs().get(source).get(i));
                }
            }
            PartitioningScheme partitioningScheme = new PartitioningScheme(node.getPartitioningScheme().getPartitioning(), newOutputSymbols, node.getPartitioningScheme().getHashColumn(), node.getPartitioningScheme().isReplicateNulls(), node.getPartitioningScheme().getBucketToPartition());
            ImmutableList.Builder rewrittenSources = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)inputsBySource.get(i));
                rewrittenSources.add((Object)context.rewrite(node.getSources().get(i), (Set<Symbol>)expectedInputs.build()));
            }
            return new ExchangeNode(node.getId(), node.getType(), node.getScope(), partitioningScheme, (List<PlanNode>)rewrittenSources.build(), inputsBySource);
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            Object outputSymbols;
            ImmutableSet expectedFilterInputs = new HashSet();
            if (node.getFilter().isPresent()) {
                expectedFilterInputs = ImmutableSet.builder().addAll(DependencyExtractor.extractUnique(node.getFilter().get())).addAll((Iterable)context.get()).build();
            }
            ImmutableSet.Builder leftInputsBuilder = ImmutableSet.builder();
            leftInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft));
            if (node.getLeftHashSymbol().isPresent()) {
                leftInputsBuilder.add((Object)node.getLeftHashSymbol().get());
            }
            leftInputsBuilder.addAll((Iterable)expectedFilterInputs);
            ImmutableSet leftInputs = leftInputsBuilder.build();
            ImmutableSet.Builder rightInputsBuilder = ImmutableSet.builder();
            rightInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight));
            if (node.getRightHashSymbol().isPresent()) {
                rightInputsBuilder.add((Object)node.getRightHashSymbol().get());
            }
            rightInputsBuilder.addAll((Iterable)expectedFilterInputs);
            ImmutableSet rightInputs = rightInputsBuilder.build();
            PlanNode left = context.rewrite(node.getLeft(), (Set<Symbol>)leftInputs);
            PlanNode right = context.rewrite(node.getRight(), (Set<Symbol>)rightInputs);
            if (node.isCrossJoin()) {
                outputSymbols = ImmutableList.builder().addAll(left.getOutputSymbols()).addAll(right.getOutputSymbols()).build();
            } else {
                HashSet seenSymbol = new HashSet();
                outputSymbols = (List)node.getOutputSymbols().stream().filter(context.get()::contains).filter(seenSymbol::add).collect(ImmutableCollectors.toImmutableList());
            }
            return new JoinNode(node.getId(), node.getType(), left, right, node.getCriteria(), (List<Symbol>)outputSymbols, node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol());
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder sourceInputsBuilder = ImmutableSet.builder();
            sourceInputsBuilder.addAll((Iterable)context.get()).add((Object)node.getSourceJoinSymbol());
            if (node.getSourceHashSymbol().isPresent()) {
                sourceInputsBuilder.add((Object)node.getSourceHashSymbol().get());
            }
            ImmutableSet sourceInputs = sourceInputsBuilder.build();
            ImmutableSet.Builder filteringSourceInputBuilder = ImmutableSet.builder();
            filteringSourceInputBuilder.add((Object)node.getFilteringSourceJoinSymbol());
            if (node.getFilteringSourceHashSymbol().isPresent()) {
                filteringSourceInputBuilder.add((Object)node.getFilteringSourceHashSymbol().get());
            }
            ImmutableSet filteringSourceInputs = filteringSourceInputBuilder.build();
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)sourceInputs);
            PlanNode filteringSource = context.rewrite(node.getFilteringSource(), (Set<Symbol>)filteringSourceInputs);
            return new SemiJoinNode(node.getId(), source, filteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol());
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder probeInputsBuilder = ImmutableSet.builder();
            probeInputsBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getProbe));
            if (node.getProbeHashSymbol().isPresent()) {
                probeInputsBuilder.add((Object)node.getProbeHashSymbol().get());
            }
            ImmutableSet probeInputs = probeInputsBuilder.build();
            ImmutableSet.Builder indexInputBuilder = ImmutableSet.builder();
            indexInputBuilder.addAll((Iterable)context.get()).addAll(Iterables.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getIndex));
            if (node.getIndexHashSymbol().isPresent()) {
                indexInputBuilder.add((Object)node.getIndexHashSymbol().get());
            }
            ImmutableSet indexInputs = indexInputBuilder.build();
            PlanNode probeSource = context.rewrite(node.getProbeSource(), (Set<Symbol>)probeInputs);
            PlanNode indexSource = context.rewrite(node.getIndexSource(), (Set<Symbol>)indexInputs);
            return new IndexJoinNode(node.getId(), node.getType(), probeSource, indexSource, node.getCriteria(), node.getProbeHashSymbol(), node.getIndexHashSymbol());
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            List newOutputSymbols = (List)node.getOutputSymbols().stream().filter(context.get()::contains).collect(ImmutableCollectors.toImmutableList());
            Set newLookupSymbols = (Set)node.getLookupSymbols().stream().filter(context.get()::contains).collect(ImmutableCollectors.toImmutableSet());
            Sets.SetView requiredAssignmentSymbols = context.get();
            if (!node.getEffectiveTupleDomain().isNone()) {
                Set requiredSymbols = Maps.filterValues(node.getAssignments(), (Predicate)Predicates.in(((Map)node.getEffectiveTupleDomain().getDomains().get()).keySet())).keySet();
                requiredAssignmentSymbols = Sets.union(context.get(), requiredSymbols);
            }
            Map newAssignments = Maps.filterKeys(node.getAssignments(), (Predicate)Predicates.in(requiredAssignmentSymbols));
            return new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), node.getLayout(), newLookupSymbols, newOutputSymbols, newAssignments, node.getEffectiveTupleDomain());
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getGroupingKeys());
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            ImmutableMap.Builder functions = ImmutableMap.builder();
            ImmutableMap.Builder functionCalls = ImmutableMap.builder();
            ImmutableMap.Builder masks = ImmutableMap.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                if (!context.get().contains(symbol)) continue;
                FunctionCall call = entry.getValue();
                expectedInputs.addAll(DependencyExtractor.extractUnique((Expression)call));
                if (node.getMasks().containsKey(symbol)) {
                    expectedInputs.add((Object)node.getMasks().get(symbol));
                    masks.put((Object)symbol, (Object)node.getMasks().get(symbol));
                }
                functionCalls.put((Object)symbol, (Object)call);
                functions.put((Object)symbol, (Object)node.getFunctions().get(symbol));
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new AggregationNode(node.getId(), source, (Map<Symbol, FunctionCall>)functionCalls.build(), (Map<Symbol, Signature>)functions.build(), (Map<Symbol, Symbol>)masks.build(), node.getGroupingSets(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol());
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getPartitionBy()).addAll(node.getOrderBy());
            for (WindowNode.Frame frame : node.getFrames()) {
                if (frame.getStartValue().isPresent()) {
                    expectedInputs.add((Object)frame.getStartValue().get());
                }
                if (!frame.getEndValue().isPresent()) continue;
                expectedInputs.add((Object)frame.getEndValue().get());
            }
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            ImmutableMap.Builder functionsBuilder = ImmutableMap.builder();
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                Symbol symbol = entry.getKey();
                WindowNode.Function function = entry.getValue();
                if (!context.get().contains(symbol)) continue;
                FunctionCall call = function.getFunctionCall();
                expectedInputs.addAll(DependencyExtractor.extractUnique((Expression)call));
                functionsBuilder.put((Object)symbol, (Object)entry.getValue());
            }
            PlanNode planNode = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            ImmutableMap immutableMap = functionsBuilder.build();
            if (immutableMap.size() == 0) {
                return planNode;
            }
            return new WindowNode(node.getId(), planNode, node.getSpecification(), (Map<Symbol, WindowNode.Function>)immutableMap, node.getHashSymbol(), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            Set requiredTableScanOutputs = (Set)context.get().stream().filter(node.getOutputSymbols()::contains).collect(ImmutableCollectors.toImmutableSet());
            List newOutputSymbols = (List)node.getOutputSymbols().stream().filter(requiredTableScanOutputs::contains).collect(ImmutableCollectors.toImmutableList());
            Map newAssignments = Maps.filterKeys(node.getAssignments(), (Predicate)Predicates.in((Collection)requiredTableScanOutputs));
            return new TableScanNode(node.getId(), node.getTable(), newOutputSymbols, newAssignments, node.getLayout(), node.getCurrentConstraint(), node.getOriginalConstraint());
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = ImmutableSet.builder().addAll(DependencyExtractor.extractUnique(node.getPredicate())).addAll((Iterable)context.get()).build();
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new FilterNode(node.getId(), source, node.getPredicate());
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder();
            Map<Symbol, Symbol> newArgumentMappings = node.getArgumentMappings().entrySet().stream().filter(entry -> ((Set)context.get()).contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            expectedInputs.addAll(newArgumentMappings.values());
            ImmutableList.Builder newGroupingSets = ImmutableList.builder();
            HashMap<Symbol, Symbol> newGroupingMapping = new HashMap<Symbol, Symbol>();
            for (List<Symbol> groupingSet : node.getGroupingSets()) {
                ImmutableList.Builder newGroupingSet = ImmutableList.builder();
                for (Symbol output : groupingSet) {
                    if (!context.get().contains(output)) continue;
                    newGroupingSet.add((Object)output);
                    newGroupingMapping.putIfAbsent(output, node.getGroupingSetMappings().get(output));
                    expectedInputs.add((Object)node.getGroupingSetMappings().get(output));
                }
                newGroupingSets.add((Object)newGroupingSet.build());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new GroupIdNode(node.getId(), source, (List<List<Symbol>>)newGroupingSets.build(), newGroupingMapping, newArgumentMappings, node.getGroupIdSymbol());
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            if (!context.get().contains(node.getMarkerSymbol())) {
                return context.rewrite(node.getSource(), context.get());
            }
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getDistinctSymbols()).addAll((Iterable)context.get().stream().filter(symbol -> !symbol.equals(node.getMarkerSymbol())).collect(ImmutableCollectors.toImmutableList()));
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new MarkDistinctNode(node.getId(), source, node.getMarkerSymbol(), node.getDistinctSymbols(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            List replicateSymbols = (List)node.getReplicateSymbols().stream().filter(context.get()::contains).collect(ImmutableCollectors.toImmutableList());
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            if (ordinalitySymbol.isPresent() && !context.get().contains(ordinalitySymbol.get())) {
                ordinalitySymbol = Optional.empty();
            }
            Map<Symbol, List<Symbol>> unnestSymbols = node.getUnnestSymbols();
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)replicateSymbols).addAll(unnestSymbols.keySet());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new UnnestNode(node.getId(), source, replicateSymbols, unnestSymbols, ordinalitySymbol);
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder();
            Assignments.Builder builder = Assignments.builder();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol output = node.getOutputSymbols().get(i);
                Expression expression = node.getAssignments().get(output);
                if (!context.get().contains(output)) continue;
                expectedInputs.addAll(DependencyExtractor.extractUnique(expression));
                builder.put(output, expression);
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new ProjectNode(node.getId(), source, builder.build());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf(node.getOutputSymbols());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new OutputNode(node.getId(), source, node.getColumnNames(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitLimit(LimitNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new LimitNode(node.getId(), source, node.getCount(), node.isPartial());
        }

        @Override
        public PlanNode visitDistinctLimit(DistinctLimitNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = node.getHashSymbol().isPresent() ? ImmutableSet.copyOf((Iterable)Iterables.concat(node.getOutputSymbols(), (Iterable)ImmutableList.of((Object)node.getHashSymbol().get()))) : ImmutableSet.copyOf(node.getOutputSymbols());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new DistinctLimitNode(node.getId(), source, node.getLimit(), node.isPartial(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitTopN(TopNNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getOrderBy());
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TopNNode(node.getId(), source, node.getCount(), node.getOrderBy(), node.getOrderings(), node.isPartial());
        }

        @Override
        public PlanNode visitRowNumber(RowNumberNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder inputsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder expectedInputs = inputsBuilder.addAll((Iterable)context.get()).addAll(node.getPartitionBy());
            if (node.getHashSymbol().isPresent()) {
                inputsBuilder.add((Object)node.getHashSymbol().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new RowNumberNode(node.getId(), source, node.getPartitionBy(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitTopNRowNumber(TopNRowNumberNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll((Iterable)context.get()).addAll(node.getPartitionBy()).addAll(node.getOrderBy());
            if (node.getHashSymbol().isPresent()) {
                expectedInputs.add((Object)node.getHashSymbol().get());
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TopNRowNumberNode(node.getId(), source, node.getSpecification(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), node.isPartial(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet expectedInputs = ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)context.get(), node.getOrderBy()));
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs);
            return new SortNode(node.getId(), source, node.getOrderBy(), node.getOrderings());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableSet.Builder expectedInputs = ImmutableSet.builder().addAll(node.getColumns());
            if (node.getPartitioningScheme().isPresent()) {
                PartitioningScheme partitioningScheme = node.getPartitioningScheme().get();
                partitioningScheme.getPartitioning().getColumns().stream().forEach(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
                partitioningScheme.getHashColumn().ifPresent(arg_0 -> ((ImmutableSet.Builder)expectedInputs).add(arg_0));
            }
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)expectedInputs.build());
            return new TableWriterNode(node.getId(), source, node.getTarget(), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getPartitioningScheme());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)ImmutableSet.copyOf(node.getSource().getOutputSymbols()));
            return new TableFinishNode(node.getId(), source, node.getTarget(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            PlanNode source = context.rewrite(node.getSource(), (Set<Symbol>)ImmutableSet.of((Object)node.getRowId()));
            return new DeleteNode(node.getId(), source, node.getTarget(), node.getRowId(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ListMultimap<Symbol, Symbol> rewrittenSymbolMapping = this.rewriteSetOperationSymbolMapping(node, context);
            ImmutableList<PlanNode> rewrittenSubPlans = this.rewriteSetOperationSubPlans(node, context, rewrittenSymbolMapping);
            return new UnionNode(node.getId(), (List<PlanNode>)rewrittenSubPlans, rewrittenSymbolMapping, (List<Symbol>)ImmutableList.copyOf((Collection)rewrittenSymbolMapping.keySet()));
        }

        @Override
        public PlanNode visitIntersect(IntersectNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ListMultimap<Symbol, Symbol> rewrittenSymbolMapping = this.rewriteSetOperationSymbolMapping(node, context);
            ImmutableList<PlanNode> rewrittenSubPlans = this.rewriteSetOperationSubPlans(node, context, rewrittenSymbolMapping);
            return new IntersectNode(node.getId(), (List<PlanNode>)rewrittenSubPlans, rewrittenSymbolMapping, (List<Symbol>)ImmutableList.copyOf((Collection)rewrittenSymbolMapping.keySet()));
        }

        @Override
        public PlanNode visitExcept(ExceptNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ListMultimap<Symbol, Symbol> rewrittenSymbolMapping = this.rewriteSetOperationSymbolMapping(node, context);
            ImmutableList<PlanNode> rewrittenSubPlans = this.rewriteSetOperationSubPlans(node, context, rewrittenSymbolMapping);
            return new ExceptNode(node.getId(), (List<PlanNode>)rewrittenSubPlans, rewrittenSymbolMapping, (List<Symbol>)ImmutableList.copyOf((Collection)rewrittenSymbolMapping.keySet()));
        }

        private ListMultimap<Symbol, Symbol> rewriteSetOperationSymbolMapping(SetOperationNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableListMultimap.Builder rewrittenSymbolMappingBuilder = ImmutableListMultimap.builder();
            for (Symbol symbol : node.getOutputSymbols()) {
                if (!context.get().contains(symbol)) continue;
                rewrittenSymbolMappingBuilder.putAll((Object)symbol, (Iterable)node.getSymbolMapping().get((Object)symbol));
            }
            return rewrittenSymbolMappingBuilder.build();
        }

        private ImmutableList<PlanNode> rewriteSetOperationSubPlans(SetOperationNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context, ListMultimap<Symbol, Symbol> rewrittenSymbolMapping) {
            ImmutableList.Builder rewrittenSubPlans = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                ImmutableSet.Builder expectedInputSymbols = ImmutableSet.builder();
                for (Collection symbols : rewrittenSymbolMapping.asMap().values()) {
                    expectedInputSymbols.add(Iterables.get((Iterable)symbols, (int)i));
                }
                rewrittenSubPlans.add((Object)context.rewrite(node.getSources().get(i), (Set<Symbol>)expectedInputSymbols.build()));
            }
            return rewrittenSubPlans.build();
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            ImmutableList.Builder rewrittenOutputSymbolsBuilder = ImmutableList.builder();
            ImmutableList.Builder rowBuildersBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getRows().size(); ++i) {
                rowBuildersBuilder.add((Object)ImmutableList.builder());
            }
            ImmutableList rowBuilders = rowBuildersBuilder.build();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol outputSymbol = node.getOutputSymbols().get(i);
                if (!context.get().contains(outputSymbol)) continue;
                rewrittenOutputSymbolsBuilder.add((Object)outputSymbol);
                for (int j = 0; j < node.getRows().size(); ++j) {
                    ((ImmutableList.Builder)rowBuilders.get(j)).add((Object)node.getRows().get(j).get(i));
                }
            }
            List rewrittenRows = (List)rowBuilders.stream().map(rowBuilder -> rowBuilder.build()).collect(ImmutableCollectors.toImmutableList());
            return new ValuesNode(node.getId(), (List<Symbol>)rewrittenOutputSymbolsBuilder.build(), rewrittenRows);
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Set<Symbol>> context) {
            if (Sets.intersection(node.getSubqueryAssignments().getSymbols(), context.get()).isEmpty()) {
                return context.rewrite(node.getInput(), context.get());
            }
            ImmutableSet.Builder subqueryAssignmentsSymbolsBuilder = ImmutableSet.builder();
            Assignments.Builder subqueryAssignments = Assignments.builder();
            for (Map.Entry<Symbol, Expression> entry : node.getSubqueryAssignments().getMap().entrySet()) {
                Symbol output = entry.getKey();
                Expression expression = entry.getValue();
                if (!context.get().contains(output)) continue;
                subqueryAssignmentsSymbolsBuilder.addAll(DependencyExtractor.extractUnique(expression));
                subqueryAssignments.put(output, expression);
            }
            ImmutableSet subqueryAssignmentsSymbols = subqueryAssignmentsSymbolsBuilder.build();
            PlanNode subquery = context.rewrite(node.getSubquery(), (Set<Symbol>)subqueryAssignmentsSymbols);
            Set<Symbol> subquerySymbols = DependencyExtractor.extractUnique(subquery);
            List newCorrelation = (List)node.getCorrelation().stream().filter(subquerySymbols::contains).collect(ImmutableCollectors.toImmutableList());
            ImmutableSet inputContext = ImmutableSet.builder().addAll((Iterable)context.get()).addAll((Iterable)newCorrelation).addAll((Iterable)subqueryAssignmentsSymbols).build();
            PlanNode input = context.rewrite(node.getInput(), (Set<Symbol>)inputContext);
            return new ApplyNode(node.getId(), input, subquery, subqueryAssignments.build(), newCorrelation);
        }
    }
}

