/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SingleMarkDistinctToGroupBy
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof AggregationNode)) {
            return Optional.empty();
        }
        AggregationNode parent = (AggregationNode)node;
        PlanNode source = lookup.resolve(parent.getSource());
        if (!(source instanceof MarkDistinctNode)) {
            return Optional.empty();
        }
        MarkDistinctNode child = (MarkDistinctNode)source;
        boolean hasFilters = parent.getAggregations().values().stream().map(FunctionCall::getFilter).anyMatch(Optional::isPresent);
        if (hasFilters) {
            return Optional.empty();
        }
        ImmutableSet masks = ImmutableSet.copyOf(parent.getMasks().values());
        if (masks.size() != 1 || parent.getMasks().size() != parent.getAggregations().size()) {
            return Optional.empty();
        }
        Symbol mask = (Symbol)Iterables.getOnlyElement((Iterable)masks);
        if (!child.getMarkerSymbol().equals(mask)) {
            return Optional.empty();
        }
        return Optional.of(new AggregationNode(idAllocator.getNextId(), new AggregationNode(idAllocator.getNextId(), child.getSource(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), (List<List<Symbol>>)ImmutableList.of(child.getDistinctSymbols()), AggregationNode.Step.SINGLE, child.getHashSymbol(), Optional.empty()), parent.getAggregations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new FunctionCall(((FunctionCall)e.getValue()).getName(), ((FunctionCall)e.getValue()).getWindow(), false, ((FunctionCall)e.getValue()).getArguments()))), parent.getFunctions(), Collections.emptyMap(), parent.getGroupingSets(), parent.getStep(), parent.getHashSymbol(), parent.getGroupIdSymbol()));
    }
}

