/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.FunctionInvoker;
import com.facebook.presto.sql.planner.DomainUtils;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.GraphvizPrinter;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlanPrinter {
    private final StringBuilder output = new StringBuilder();
    private final Metadata metadata;
    private final Optional<Map<PlanNodeId, PlanNodeStats>> stats;

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session sesion) {
        this(plan, types, metadata, sesion, 0);
    }

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, int indent) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.stats = Optional.empty();
        Visitor visitor = new Visitor(types, session);
        plan.accept(visitor, indent);
    }

    private PlanPrinter(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, Map<PlanNodeId, PlanNodeStats> stats, int indent) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.stats = Optional.of(stats);
        Visitor visitor = new Visitor(types, session);
        plan.accept(visitor, indent);
    }

    public String toString() {
        return this.output.toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session) {
        return new PlanPrinter(plan, types, metadata, session).toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, int indent) {
        return new PlanPrinter(plan, types, metadata, session, indent).toString();
    }

    public static String textLogicalPlan(PlanNode plan, Map<Symbol, Type> types, Metadata metadata, Session session, Map<PlanNodeId, PlanNodeStats> stats, int indent) {
        return new PlanPrinter(plan, types, metadata, session, stats, indent).toString();
    }

    public static String textDistributedPlan(List<StageInfo> stages, Metadata metadata, Session session) {
        StringBuilder builder = new StringBuilder();
        List allStages = (List)stages.stream().flatMap(stage -> StageInfo.getAllStages(Optional.of(stage)).stream()).collect(ImmutableCollectors.toImmutableList());
        for (StageInfo stageInfo : allStages) {
            HashMap<PlanNodeId, PlanNodeStats> aggregatedStats = new HashMap<PlanNodeId, PlanNodeStats>();
            List planNodeStats = stageInfo.getTasks().stream().map(TaskInfo::getStats).flatMap(taskStats -> PlanPrinter.getPlanNodeStats(taskStats).stream()).collect(Collectors.toList());
            for (PlanNodeStats stats : planNodeStats) {
                aggregatedStats.merge(stats.getPlanNodeId(), stats, PlanNodeStats::merge);
            }
            builder.append(PlanPrinter.formatFragment(metadata, session, stageInfo.getPlan(), Optional.of(stageInfo.getStageStats()), Optional.of(aggregatedStats)));
        }
        return builder.toString();
    }

    private static List<PlanNodeStats> getPlanNodeStats(TaskStats taskStats) {
        HashMap<PlanNodeId, Long> inputPositions = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> inputBytes = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> outputPositions = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> outputBytes = new HashMap<PlanNodeId, Long>();
        HashMap<PlanNodeId, Long> wallMillis = new HashMap<PlanNodeId, Long>();
        for (PipelineStats pipelineStats : taskStats.getPipelines()) {
            PlanNodeId planNodeId;
            if (pipelineStats.getOperatorSummaries().isEmpty()) continue;
            HashSet<PlanNodeId> processedNodes = new HashSet<PlanNodeId>();
            PlanNodeId inputPlanNode = pipelineStats.getOperatorSummaries().iterator().next().getPlanNodeId();
            PlanNodeId outputPlanNode = ((OperatorStats)Iterables.getLast(pipelineStats.getOperatorSummaries())).getPlanNodeId();
            for (OperatorStats operatorStats : pipelineStats.getOperatorSummaries()) {
                planNodeId = operatorStats.getPlanNodeId();
                long wall = operatorStats.getAddInputWall().toMillis() + operatorStats.getGetOutputWall().toMillis() + operatorStats.getFinishWall().toMillis();
                wallMillis.merge(planNodeId, wall, Long::sum);
                if (operatorStats.getPlanNodeId().equals(inputPlanNode) && !pipelineStats.isInputPipeline() || processedNodes.contains(planNodeId)) continue;
                inputPositions.merge(planNodeId, operatorStats.getInputPositions(), Long::sum);
                inputBytes.merge(planNodeId, operatorStats.getInputDataSize().toBytes(), Long::sum);
                processedNodes.add(planNodeId);
            }
            processedNodes.clear();
            for (OperatorStats operatorStats : Lists.reverse(pipelineStats.getOperatorSummaries())) {
                planNodeId = operatorStats.getPlanNodeId();
                if (operatorStats.getPlanNodeId().equals(outputPlanNode) && !pipelineStats.isOutputPipeline() || processedNodes.contains(planNodeId)) continue;
                outputPositions.merge(planNodeId, operatorStats.getOutputPositions(), Long::sum);
                outputBytes.merge(planNodeId, operatorStats.getOutputDataSize().toBytes(), Long::sum);
                processedNodes.add(planNodeId);
            }
        }
        ArrayList<PlanNodeStats> stats = new ArrayList<PlanNodeStats>();
        for (Map.Entry entry : wallMillis.entrySet()) {
            PlanNodeId planNodeId = (PlanNodeId)entry.getKey();
            stats.add(new PlanNodeStats((PlanNodeId)entry.getKey(), new Duration((double)((Long)entry.getValue()).longValue(), TimeUnit.MILLISECONDS), (Long)inputPositions.get(planNodeId), DataSize.succinctDataSize((double)((Long)inputBytes.get(planNodeId)).longValue(), (DataSize.Unit)DataSize.Unit.BYTE), outputPositions.getOrDefault(planNodeId, 0L), DataSize.succinctDataSize((double)outputBytes.getOrDefault(planNodeId, 0L).longValue(), (DataSize.Unit)DataSize.Unit.BYTE)));
        }
        return stats;
    }

    public static String textDistributedPlan(SubPlan plan, Metadata metadata, Session session) {
        StringBuilder builder = new StringBuilder();
        for (PlanFragment fragment : plan.getAllFragments()) {
            builder.append(PlanPrinter.formatFragment(metadata, session, fragment, Optional.empty(), Optional.empty()));
        }
        return builder.toString();
    }

    private static String formatFragment(Metadata metadata, Session session, PlanFragment fragment, Optional<StageStats> stageStats, Optional<Map<PlanNodeId, PlanNodeStats>> planNodeStats) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Fragment %s [%s]\n", fragment.getId(), fragment.getPartitioning()));
        if (stageStats.isPresent()) {
            builder.append(PlanPrinter.indentString(1)).append(String.format("Cost: CPU %s, Input: %s (%s), Output: %s (%s)\n", stageStats.get().getTotalCpuTime(), PlanPrinter.formatPositions(stageStats.get().getProcessedInputPositions()), stageStats.get().getProcessedInputDataSize(), PlanPrinter.formatPositions(stageStats.get().getOutputPositions()), stageStats.get().getOutputDataSize()));
        }
        PartitioningScheme partitioningScheme = fragment.getPartitioningScheme();
        builder.append(PlanPrinter.indentString(1)).append(String.format("Output layout: [%s]\n", Joiner.on((String)", ").join(partitioningScheme.getOutputLayout())));
        boolean replicateNulls = partitioningScheme.isReplicateNulls();
        List arguments = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
            if (argument.isConstant()) {
                NullableValue constant = argument.getConstant();
                String printableValue = PlanPrinter.castToVarchar(constant.getType(), constant.getValue(), metadata, session);
                return constant.getType().getDisplayName() + "(" + printableValue + ")";
            }
            return argument.getColumn().toString();
        }).collect(ImmutableCollectors.toImmutableList());
        builder.append(PlanPrinter.indentString(1));
        if (replicateNulls) {
            builder.append(String.format("Output partitioning: %s (replicate nulls) [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        } else {
            builder.append(String.format("Output partitioning: %s [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        }
        if (stageStats.isPresent()) {
            builder.append(PlanPrinter.textLogicalPlan(fragment.getRoot(), fragment.getSymbols(), metadata, session, planNodeStats.get(), 1)).append("\n");
        } else {
            builder.append(PlanPrinter.textLogicalPlan(fragment.getRoot(), fragment.getSymbols(), metadata, session, 1)).append("\n");
        }
        return builder.toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, Map<Symbol, Type> types) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan, types, SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<PlanNodeId>)ImmutableList.of((Object)plan.getId()), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getOutputSymbols()));
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private void print(int indent, String format, Object ... args) {
        String value = args.length == 0 ? format : String.format(format, args);
        this.output.append(PlanPrinter.indentString(indent)).append(value).append('\n');
    }

    private void print(int indent, String format, List<Object> args) {
        this.print(indent, format, args.toArray(new Object[args.size()]));
    }

    private void printStats(int intent, PlanNodeId planNodeId) {
        this.printStats(intent, planNodeId, false, false);
    }

    private void printStats(int indent, PlanNodeId planNodeId, boolean printInput, boolean printFiltered) {
        if (!this.stats.isPresent()) {
            return;
        }
        long totalMillis = this.stats.get().values().stream().mapToLong(node -> node.getWallTime().toMillis()).sum();
        PlanNodeStats nodeStats = this.stats.get().get(planNodeId);
        if (nodeStats == null) {
            this.output.append(PlanPrinter.indentString(indent));
            this.output.append("Cost: ?");
            if (printInput) {
                this.output.append(", Input: ? lines (?B)");
            }
            this.output.append(", Output: ? lines (?B)");
            if (printFiltered) {
                this.output.append(", Filtered: ?%");
            }
            this.output.append('\n');
            return;
        }
        double fraction = (double)nodeStats.getWallTime().toMillis() / (double)totalMillis;
        String fractionString = Double.isFinite(fraction) ? String.format(Locale.US, "%.2f%%", 100.0 * fraction) : "?";
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append("Cost: " + fractionString);
        if (printInput) {
            this.output.append(String.format(", Input: %s (%s)", PlanPrinter.formatPositions(nodeStats.getInputPositions()), nodeStats.getInputDataSize().toString()));
        }
        this.output.append(String.format(", Output: %s (%s)", PlanPrinter.formatPositions(nodeStats.getOutputPositions()), nodeStats.getOutputDataSize().toString()));
        if (printFiltered) {
            double filtered = 100.0 * (double)(nodeStats.getInputPositions() - nodeStats.getOutputPositions()) / (double)nodeStats.getInputPositions();
            String filteredString = Double.isFinite(filtered) ? String.format(Locale.US, "%.2f%%", filtered) : "?";
            this.output.append(", Filtered: " + filteredString);
        }
        this.output.append('\n');
    }

    private static String formatPositions(long positions) {
        if (positions == 1L) {
            return "1 row";
        }
        return positions + " rows";
    }

    private static String indentString(int indent) {
        return Strings.repeat((String)"    ", (int)indent);
    }

    private static String formatHash(Optional<Symbol> ... hashes) {
        List symbols = Arrays.stream(hashes).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (symbols.isEmpty()) {
            return "";
        }
        return "[" + Joiner.on((String)", ").join(symbols) + "]";
    }

    private static String formatFrame(WindowFrame frame) {
        StringBuilder builder = new StringBuilder(frame.getType().toString());
        FrameBound start = frame.getStart();
        if (start.getValue().isPresent()) {
            builder.append(" ").append(start.getOriginalValue().get());
        }
        builder.append(" ").append(start.getType());
        Optional end = frame.getEnd();
        if (end.isPresent()) {
            if (((FrameBound)end.get()).getOriginalValue().isPresent()) {
                builder.append(" ").append(((FrameBound)end.get()).getOriginalValue().get());
            }
            builder.append(" ").append(((FrameBound)end.get()).getType());
        }
        return builder.toString();
    }

    private static String castToVarchar(Type type, Object value, Metadata metadata, Session session) {
        if (value == null) {
            return "NULL";
        }
        Signature coercion = metadata.getFunctionRegistry().getCoercion(type, (Type)VarcharType.VARCHAR);
        try {
            Slice coerced = (Slice)new FunctionInvoker(metadata.getFunctionRegistry()).invoke(coercion, session.toConnectorSession(), value);
            return coerced.toStringUtf8();
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    private static class PlanNodeStats {
        private final PlanNodeId planNodeId;
        private final Duration wallTime;
        private final long inputPositions;
        private final DataSize inputDataSize;
        private final long outputPositions;
        private final DataSize outputDataSize;

        private PlanNodeStats(PlanNodeId planNodeId, Duration wallTime, long inputPositions, DataSize inputDataSize, long outputPositions, DataSize outputDataSize) {
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.wallTime = Objects.requireNonNull(wallTime, "wallTime is null");
            this.inputPositions = inputPositions;
            this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
            this.outputPositions = outputPositions;
            this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        }

        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        public Duration getWallTime() {
            return this.wallTime;
        }

        public long getInputPositions() {
            return this.inputPositions;
        }

        public DataSize getInputDataSize() {
            return this.inputDataSize;
        }

        public long getOutputPositions() {
            return this.outputPositions;
        }

        public DataSize getOutputDataSize() {
            return this.outputDataSize;
        }

        public static PlanNodeStats merge(PlanNodeStats planNodeStats1, PlanNodeStats planNodeStats2) {
            Preconditions.checkArgument((boolean)planNodeStats1.getPlanNodeId().equals(planNodeStats2.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object[])new Object[]{planNodeStats1.getPlanNodeId(), planNodeStats2.getPlanNodeId()});
            long inputPositions = planNodeStats1.inputPositions + planNodeStats2.inputPositions;
            DataSize inputDataSize = DataSize.succinctBytes((long)(planNodeStats1.inputDataSize.toBytes() + planNodeStats2.inputDataSize.toBytes()));
            long outputPositions = planNodeStats1.outputPositions + planNodeStats2.outputPositions;
            DataSize outputDataSize = DataSize.succinctBytes((long)(planNodeStats1.outputDataSize.toBytes() + planNodeStats2.outputDataSize.toBytes()));
            return new PlanNodeStats(planNodeStats1.getPlanNodeId(), new Duration((double)(planNodeStats1.getWallTime().toMillis() + planNodeStats2.getWallTime().toMillis()), TimeUnit.MILLISECONDS), inputPositions, inputDataSize, outputPositions, outputDataSize);
        }
    }

    private class Visitor
    extends PlanVisitor<Integer, Void> {
        private final Map<Symbol, Type> types;
        private final Session session;

        public Visitor(Map<Symbol, Type> types, Session session) {
            this.types = types;
            this.session = session;
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- ExplainAnalyze => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitJoin(JoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)clause.getLeft().toSymbolReference(), (Expression)clause.getRight().toSymbolReference()));
            }
            node.getFilter().ifPresent(expression -> joinExpressions.add((ComparisonExpression)expression));
            if (node.getType() == JoinNode.Type.INNER && joinExpressions.isEmpty()) {
                PlanPrinter.this.print(indent, "- CrossJoin => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            } else {
                PlanPrinter.this.print(indent, "- %s[%s]%s => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(new Optional[]{node.getLeftHashSymbol(), node.getRightHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            }
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getLeft().accept(this, indent + 1);
            node.getRight().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- SemiJoin[%s = %s]%s => [%s]", new Object[]{node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), PlanPrinter.formatHash(new Optional[]{node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getSource().accept(this, indent + 1);
            node.getFilteringSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- IndexSource[%s, lookup = %s] => [%s]", new Object[]{node.getIndexHandle(), node.getLookupSymbols(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)clause.getProbe().toSymbolReference(), (Expression)clause.getIndex().toSymbolReference()));
            }
            PlanPrinter.this.print(indent, "- %sIndexJoin[%s]%s => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(new Optional[]{node.getProbeHashSymbol(), node.getIndexHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getProbeSource().accept(this, indent + 1);
            node.getIndexSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Limit%s[%s] => [%s]", new Object[]{node.isPartial() ? "Partial" : "", node.getCount(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- DistinctLimit%s[%s]%s => [%s]", new Object[]{node.isPartial() ? "Partial" : "", node.getLimit(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Integer indent) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            String key = "";
            if (!node.getGroupingKeys().isEmpty()) {
                key = node.getGroupingKeys().toString();
            }
            PlanPrinter.this.print(indent, "- Aggregate%s%s%s => [%s]", new Object[]{type, key, PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                if (node.getMasks().containsKey(entry.getKey())) {
                    PlanPrinter.this.print(indent + 2, "%s := %s (mask = %s)", new Object[]{entry.getKey(), entry.getValue(), node.getMasks().get(entry.getKey())});
                    continue;
                }
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Integer indent) {
            List inputGroupingSetSymbols = node.getGroupingSets().stream().map(set -> set.stream().map(symbol -> node.getGroupingSetMappings().get(symbol)).collect(Collectors.toList())).collect(Collectors.toList());
            PlanPrinter.this.print(indent, "- GroupId%s => [%s]", new Object[]{inputGroupingSetSymbols, this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, Symbol> mapping : node.getGroupingSetMappings().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{mapping.getKey(), mapping.getValue()});
            }
            for (Map.Entry<Symbol, Symbol> argument : node.getArgumentMappings().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{argument.getKey(), argument.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MarkDistinct[distinct=%s marker=%s]%s => [%s]", new Object[]{this.formatOutputs(node.getDistinctSymbols()), node.getMarkerSymbol(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitWindow(WindowNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableCollectors.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableCollectors.toImmutableList());
                StringBuilder builder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    builder.append("<").append(Joiner.on((String)", ").join((Iterable)prePartitioned)).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    builder.append(Joiner.on((String)", ").join((Iterable)notPrePartitioned));
                }
                args.add(String.format("partition by (%s)", builder));
            }
            if (!orderBy.isEmpty()) {
                args.add(String.format("order by (%s)", Stream.concat(node.getOrderBy().stream().limit(node.getPreSortedOrderPrefix()).map(symbol -> "<" + symbol + " " + node.getOrderings().get(symbol) + ">"), node.getOrderBy().stream().skip(node.getPreSortedOrderPrefix()).map(symbol -> symbol + " " + node.getOrderings().get(symbol))).collect(Collectors.joining(", "))));
            }
            PlanPrinter.this.print(indent, "- Window[%s]%s => [%s]", new Object[]{Joiner.on((String)", ").join(args), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                FunctionCall call = entry.getValue().getFunctionCall();
                String frameInfo = call.getWindow().flatMap(Window::getFrame).map(x$0 -> PlanPrinter.formatFrame(x$0)).orElse("");
                PlanPrinter.this.print(indent + 2, "%s := %s(%s) %s", new Object[]{entry.getKey(), call.getName(), Joiner.on((String)", ").join((Iterable)call.getArguments()), frameInfo});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            List orderBy = Lists.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            PlanPrinter.this.print(indent, "- TopNRowNumber[%s limit %s]%s => [%s]", new Object[]{Joiner.on((String)", ").join(args), node.getMaxRowCountPerPartition(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                args.add(String.format("limit = %s", node.getMaxRowCountPerPartition().get()));
            }
            PlanPrinter.this.print(indent, "- RowNumber[%s]%s => [%s]", new Object[]{Joiner.on((String)", ").join(args), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Integer indent) {
            TableHandle table = node.getTable();
            PlanPrinter.this.print(indent, "- TableScan[%s, originalConstraint = %s] => [%s]", new Object[]{table, node.getOriginalConstraint(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            this.printTableScanInfo(node, indent);
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Values => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (List<Expression> row : node.getRows()) {
                PlanPrinter.this.print(indent + 2, "(" + Joiner.on((String)", ").join(row) + ")", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Integer indent) {
            return this.visitScanFilterAndProjectInfo(node.getId(), Optional.of(node), Optional.empty(), indent);
        }

        @Override
        public Void visitProject(ProjectNode node, Integer indent) {
            if (node.getSource() instanceof FilterNode) {
                return this.visitScanFilterAndProjectInfo(node.getId(), Optional.of((FilterNode)node.getSource()), Optional.of(node), indent);
            }
            return this.visitScanFilterAndProjectInfo(node.getId(), Optional.empty(), Optional.of(node), indent);
        }

        private Void visitScanFilterAndProjectInfo(PlanNodeId planNodeId, Optional<FilterNode> filterNode, Optional<ProjectNode> projectNode, int indent) {
            Preconditions.checkState((projectNode.isPresent() || filterNode.isPresent() ? 1 : 0) != 0);
            PlanNode sourceNode = filterNode.isPresent() ? filterNode.get().getSource() : projectNode.get().getSource();
            Optional<Object> scanNode = sourceNode instanceof TableScanNode ? Optional.of((TableScanNode)sourceNode) : Optional.empty();
            String format = "[";
            String operatorName = "- ";
            LinkedList<Object> arguments = new LinkedList<Object>();
            if (scanNode.isPresent()) {
                operatorName = operatorName + "Scan";
                format = format + "table = %s, originalConstraint = %s";
                if (filterNode.isPresent()) {
                    format = format + ", ";
                }
                TableHandle table = ((TableScanNode)scanNode.get()).getTable();
                arguments.add(table);
                arguments.add(((TableScanNode)scanNode.get()).getOriginalConstraint());
            }
            if (filterNode.isPresent()) {
                operatorName = operatorName + "Filter";
                format = format + "filterPredicate = %s";
                arguments.add(filterNode.get().getPredicate());
            }
            format = format + "] => [%s]";
            if (projectNode.isPresent()) {
                operatorName = operatorName + "Project";
                arguments.add(this.formatOutputs(projectNode.get().getOutputSymbols()));
            } else {
                arguments.add(this.formatOutputs(filterNode.get().getOutputSymbols()));
            }
            format = operatorName + format;
            PlanPrinter.this.print(indent, format, arguments);
            PlanPrinter.this.printStats(indent + 2, planNodeId, true, true);
            if (projectNode.isPresent()) {
                this.printAssignments(projectNode.get().getAssignments(), indent + 2);
            }
            if (scanNode.isPresent()) {
                this.printTableScanInfo((TableScanNode)scanNode.get(), indent);
                return null;
            }
            sourceNode.accept(this, indent + 1);
            return null;
        }

        private void printTableScanInfo(TableScanNode node, int indent) {
            TableHandle table = node.getTable();
            TupleDomain predicate = node.getLayout().map(layoutHandle -> PlanPrinter.this.metadata.getLayout(this.session, (TableLayoutHandle)layoutHandle)).map(TableLayout::getPredicate).orElse(TupleDomain.all());
            if (node.getLayout().isPresent()) {
                ConnectorTableLayoutHandle layout = node.getLayout().get().getConnectorHandle();
                if (!table.getConnectorHandle().toString().equals(layout.toString())) {
                    PlanPrinter.this.print(indent + 2, "LAYOUT: %s", new Object[]{layout});
                }
            }
            if (predicate.isNone()) {
                PlanPrinter.this.print(indent + 2, ":: NONE", new Object[0]);
            } else {
                for (Map.Entry entry2 : node.getAssignments().entrySet()) {
                    ColumnHandle column = (ColumnHandle)entry2.getValue();
                    PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry2.getKey(), column});
                    this.printConstraint(indent + 3, column, (TupleDomain<ColumnHandle>)predicate);
                }
                if (!predicate.isAll()) {
                    ImmutableSet outputs = ImmutableSet.copyOf(node.getAssignments().values());
                    ((Map)predicate.getDomains().get()).entrySet().stream().filter(arg_0 -> Visitor.lambda$printTableScanInfo$10((Set)outputs, arg_0)).forEach(entry -> {
                        ColumnHandle column = (ColumnHandle)entry.getKey();
                        PlanPrinter.this.print(indent + 2, "%s", new Object[]{column});
                        this.printConstraint(indent + 3, column, (TupleDomain<ColumnHandle>)predicate);
                    });
                }
            }
        }

        @Override
        public Void visitUnnest(UnnestNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Unnest [replicate=%s, unnest=%s] => [%s]", new Object[]{this.formatOutputs(node.getReplicateSymbols()), this.formatOutputs(node.getUnnestSymbols().keySet()), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitOutput(OutputNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Output[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(node.getColumnNames()), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopN(TopNNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            PlanPrinter.this.print(indent, "- TopN[%s by (%s)] => [%s]", new Object[]{node.getCount(), Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSort(SortNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderBy(), input -> input + " " + node.getOrderings().get(input));
            PlanPrinter.this.print(indent, "- Sort[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- RemoteSource[%s] => [%s]", new Object[]{Joiner.on((char)',').join(node.getSourceFragmentIds()), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Union => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitIntersect(IntersectNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Intersect => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExcept(ExceptNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Except => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableWriter => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableCommit[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSample(SampleNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Sample[%s: %s] => [%s]", new Object[]{node.getSampleType(), node.getSampleRatio(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Integer indent) {
            if (node.getScope() == ExchangeNode.Scope.LOCAL) {
                PlanPrinter.this.print(indent, "- LocalExchange[%s%s]%s (%s) => %s", new Object[]{node.getPartitioningScheme().getPartitioning().getHandle(), node.getPartitioningScheme().isReplicateNulls() ? " - REPLICATE NULLS" : "", PlanPrinter.formatHash(new Optional[]{node.getPartitioningScheme().getHashColumn()}), Joiner.on((String)", ").join(node.getPartitioningScheme().getPartitioning().getArguments()), this.formatOutputs(node.getOutputSymbols())});
            } else {
                PlanPrinter.this.print(indent, "- %sExchange[%s%s]%s => %s", new Object[]{CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString()), node.getType(), node.getPartitioningScheme().isReplicateNulls() ? " - REPLICATE NULLS" : "", PlanPrinter.formatHash(new Optional[]{node.getPartitioningScheme().getHashColumn()}), this.formatOutputs(node.getOutputSymbols())});
            }
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDelete(DeleteNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Delete[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMetadataDelete(MetadataDeleteNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MetadataDelete[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Scalar => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Integer indent) {
            PlanPrinter.this.print(indent, "- AssignUniqueId => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitApply(ApplyNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Apply[%s] => [%s]", new Object[]{node.getCorrelation(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            this.printAssignments(node.getSubqueryAssignments(), indent + 4);
            return this.processChildren(node, indent + 1);
        }

        @Override
        protected Void visitPlan(PlanNode node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, int indent) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, indent);
            }
            return null;
        }

        private void printAssignments(Assignments assignments, int indent) {
            for (Map.Entry<Symbol, Expression> entry : assignments.getMap().entrySet()) {
                if (entry.getValue() instanceof SymbolReference && ((SymbolReference)entry.getValue()).getName().equals(entry.getKey().getName())) continue;
                PlanPrinter.this.print(indent, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
        }

        private String formatOutputs(Iterable<Symbol> symbols) {
            return Joiner.on((String)", ").join(Iterables.transform(symbols, input -> input + ":" + this.types.get(input).getDisplayName()));
        }

        private void printConstraint(int indent, ColumnHandle column, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            Map domains = (Map)constraint.getDomains().get();
            if (!constraint.isAll() && domains.containsKey(column)) {
                PlanPrinter.this.print(indent, ":: %s", new Object[]{this.formatDomain(DomainUtils.simplifyDomain((Domain)domains.get(column)))});
            }
        }

        private String formatDomain(Domain domain) {
            ImmutableList.Builder parts = ImmutableList.builder();
            if (domain.isNullAllowed()) {
                parts.add((Object)"NULL");
            }
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> {
                for (Range range : ranges.getOrderedRanges()) {
                    StringBuilder builder = new StringBuilder();
                    if (range.isSingleValue()) {
                        String value = PlanPrinter.castToVarchar(type, range.getSingleValue(), PlanPrinter.this.metadata, this.session);
                        builder.append('[').append(value).append(']');
                    } else {
                        builder.append(range.getLow().getBound() == Marker.Bound.EXACTLY ? (char)'[' : (char)'(');
                        if (range.getLow().isLowerUnbounded()) {
                            builder.append("<min>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getLow().getValue(), PlanPrinter.this.metadata, this.session));
                        }
                        builder.append(", ");
                        if (range.getHigh().isUpperUnbounded()) {
                            builder.append("<max>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getHigh().getValue(), PlanPrinter.this.metadata, this.session));
                        }
                        builder.append(range.getHigh().getBound() == Marker.Bound.EXACTLY ? (char)']' : (char)')');
                    }
                    parts.add((Object)builder.toString());
                }
            }, discreteValues -> discreteValues.getValues().stream().map(value -> PlanPrinter.castToVarchar(type, value, PlanPrinter.this.metadata, this.session)).sorted().forEach(arg_0 -> ((ImmutableList.Builder)parts).add(arg_0)), allOrNone -> {
                if (allOrNone.isAll()) {
                    parts.add((Object)"ALL VALUES");
                }
            });
            return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
        }

        private static /* synthetic */ boolean lambda$printTableScanInfo$10(Set outputs, Map.Entry entry) {
            return !outputs.contains(entry.getKey());
        }
    }
}

