/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class LambdaAndTryExpressionExtractor {
    private LambdaAndTryExpressionExtractor() {
    }

    public static List<RowExpression> extractLambdaAndTryExpressions(RowExpression expression) {
        Visitor visitor = new Visitor();
        expression.accept(visitor, new Context(false));
        return visitor.getLambdaAndTryExpressionsPostOrder();
    }

    private static class Context {
        private final boolean inLambda;

        public Context(boolean inLambda) {
            this.inLambda = inLambda;
        }

        public boolean isInLambda() {
            return this.inLambda;
        }
    }

    private static class Visitor
    implements RowExpressionVisitor<Context, Void> {
        private final ImmutableList.Builder<RowExpression> lambdaAndTryExpressions = ImmutableList.builder();

        private Visitor() {
        }

        @Override
        public Void visitInputReference(InputReferenceExpression node, Context context) {
            return null;
        }

        @Override
        public Void visitCall(CallExpression call, Context context) {
            boolean isTry = call.getSignature().getName().equals("TRY");
            if (isTry) {
                Preconditions.checkState((call.getArguments().size() == 1 ? 1 : 0) != 0, (Object)"try call expressions must have a single argument");
                Preconditions.checkState((boolean)(Iterables.getOnlyElement(call.getArguments()) instanceof CallExpression), (Object)"try call expression argument must be a call expression");
                if (context.isInLambda()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Try expression inside lambda expression is not support yet");
                }
            }
            for (RowExpression rowExpression : call.getArguments()) {
                rowExpression.accept(this, context);
            }
            if (isTry) {
                this.lambdaAndTryExpressions.add(Iterables.getOnlyElement(call.getArguments()));
            }
            return null;
        }

        @Override
        public Void visitConstant(ConstantExpression literal, Context context) {
            return null;
        }

        @Override
        public Void visitLambda(LambdaDefinitionExpression lambda, Context context) {
            lambda.getBody().accept(this, new Context(true));
            this.lambdaAndTryExpressions.add((Object)lambda);
            return null;
        }

        @Override
        public Void visitVariableReference(VariableReferenceExpression reference, Context context) {
            return null;
        }

        private List<RowExpression> getLambdaAndTryExpressionsPostOrder() {
            return this.lambdaAndTryExpressions.build();
        }
    }
}

