/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.Objects;
import java.util.function.BiFunction;

class InputReferenceCompiler
implements RowExpressionVisitor<Scope, BytecodeNode> {
    private final BiFunction<Scope, Integer, BytecodeExpression> blockResolver;
    private final BiFunction<Scope, Integer, BytecodeExpression> positionResolver;
    private final CallSiteBinder callSiteBinder;

    public InputReferenceCompiler(BiFunction<Scope, Integer, BytecodeExpression> blockResolver, BiFunction<Scope, Integer, BytecodeExpression> positionResolver, CallSiteBinder callSiteBinder) {
        this.blockResolver = Objects.requireNonNull(blockResolver, "blockResolver is null");
        this.positionResolver = Objects.requireNonNull(positionResolver, "positionResolver is null");
        this.callSiteBinder = Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
    }

    @Override
    public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
        int field = node.getField();
        Type type = node.getType();
        BytecodeExpression block = this.blockResolver.apply(scope, field);
        BytecodeExpression position = this.positionResolver.apply(scope, field);
        Variable wasNullVariable = scope.getVariable("wasNull");
        Class<Object> javaType = type.getJavaType();
        if (!javaType.isPrimitive() && javaType != Slice.class) {
            javaType = Object.class;
        }
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}));
        ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
        String methodName = "get" + Primitives.wrap(javaType).getSimpleName();
        ifStatement.ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(this.callSiteBinder, type).invoke(methodName, javaType, new BytecodeExpression[]{block, position}));
        return ifStatement;
    }

    @Override
    public BytecodeNode visitCall(CallExpression call, Scope scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
        throw new UnsupportedOperationException();
    }
}

