/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.ForLoop;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BodyCompiler;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.LambdaAndTryExpressionExtractor;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.TryCodeGenerator;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;

public class CursorProcessorCompiler
implements BodyCompiler<CursorProcessor> {
    private final Metadata metadata;

    public CursorProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        CursorProcessorCompiler.generateProcessMethod(classDefinition, projections.size());
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, filter);
        for (int i = 0; i < projections.size(); ++i) {
            this.generateProjectMethod(classDefinition, callSiteBinder, cachedInstanceBinder, "project_" + i, projections.get(i));
        }
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, int projections) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter count = Parameter.arg((String)"count", Integer.TYPE);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(Integer.TYPE), new Parameter[]{session, cursor, count, pageBuilder});
        Scope scope = method.getScope();
        Variable completedPositionsVariable = scope.declareVariable(Integer.TYPE, "completedPositions");
        method.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0);
        LabelNode done = new LabelNode("done");
        ForLoop forLoop = new ForLoop().initialize((BytecodeNode)OpCode.NOP).condition((BytecodeNode)new BytecodeBlock().comment("completedPositions < count").getVariable(completedPositionsVariable).getVariable((Variable)count).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, new Class[]{Integer.TYPE, Integer.TYPE})).update((BytecodeNode)new BytecodeBlock().comment("completedPositions++").incrementVariable(completedPositionsVariable, (byte)1));
        BytecodeBlock forLoopBody = new BytecodeBlock().comment("if (pageBuilder.isFull()) break;").append((BytecodeNode)new BytecodeBlock().getVariable((Variable)pageBuilder).invokeVirtual(PageBuilder.class, "isFull", Boolean.TYPE, new Class[0]).ifTrueGoto(done)).comment("if (!cursor.advanceNextPosition()) break;").append((BytecodeNode)new BytecodeBlock().getVariable((Variable)cursor).invokeInterface(RecordCursor.class, "advanceNextPosition", Boolean.TYPE, new Class[0]).ifFalseGoto(done));
        forLoop.body((BytecodeNode)forLoopBody);
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append((BytecodeNode)method.getThis()).getVariable((Variable)session).getVariable((Variable)cursor).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), new ParameterizedType[]{ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class)});
        ifStatement.ifTrue().getVariable((Variable)pageBuilder).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (int projectionIndex = 0; projectionIndex < projections; ++projectionIndex) {
            ifStatement.ifTrue().append((BytecodeNode)method.getThis()).getVariable((Variable)session).getVariable((Variable)cursor);
            ifStatement.ifTrue().getVariable((Variable)pageBuilder).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, new Class[]{Integer.TYPE});
            ifStatement.ifTrue().invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), new ParameterizedType[]{ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class)});
        }
        forLoopBody.append((BytecodeNode)ifStatement);
        method.getBody().append((BytecodeNode)forLoop).visitLabel(done).comment("return completedPositions;").getVariable(completedPositionsVariable).retInt();
    }

    private PreGeneratedExpressions generateMethodsForLambdaAndTry(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression projection, String methodPrefix) {
        ImmutableSet lambdaAndTryExpressions = ImmutableSet.copyOf(LambdaAndTryExpressionExtractor.extractLambdaAndTryExpressions(projection));
        ImmutableMap.Builder tryMethodMap = ImmutableMap.builder();
        ImmutableMap.Builder lambdaFieldMap = ImmutableMap.builder();
        int counter = 0;
        for (RowExpression expression : lambdaAndTryExpressions) {
            if (expression instanceof CallExpression) {
                CallExpression tryExpression = (CallExpression)expression;
                Verify.verify((!"TRY".equals(tryExpression.getSignature().getName()) ? 1 : 0) != 0);
                Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
                Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
                ImmutableList inputParameters = ImmutableList.builder().add((Object)session).add((Object)cursor).build();
                BytecodeExpressionVisitor innerExpressionVisitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.metadata.getFunctionRegistry(), new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, FieldDefinition>)lambdaFieldMap.build()));
                MethodDefinition tryMethod = TryCodeGenerator.defineTryMethod(innerExpressionVisitor, containerClassDefinition, methodPrefix + "_try_" + counter, (List<Parameter>)inputParameters, Primitives.wrap((Class)tryExpression.getType().getJavaType()), tryExpression, callSiteBinder);
                tryMethodMap.put((Object)tryExpression, (Object)tryMethod);
            } else if (expression instanceof LambdaDefinitionExpression) {
                LambdaDefinitionExpression lambdaExpression = (LambdaDefinitionExpression)expression;
                String fieldName = methodPrefix + "_lambda_" + counter;
                PreGeneratedExpressions preGeneratedExpressions = new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, FieldDefinition>)lambdaFieldMap.build());
                FieldDefinition methodHandleField = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, fieldName, containerClassDefinition, preGeneratedExpressions, callSiteBinder, cachedInstanceBinder, this.metadata.getFunctionRegistry());
                lambdaFieldMap.put((Object)lambdaExpression, (Object)methodHandleField);
            } else {
                throw new VerifyException(String.format("unexpected expression: %s", expression.toString()));
            }
            ++counter;
        }
        return new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, FieldDefinition>)lambdaFieldMap.build());
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression filter) {
        PreGeneratedExpressions preGeneratedExpressions = this.generateMethodsForLambdaAndTry(classDefinition, callSiteBinder, cachedInstanceBinder, filter, "filter");
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), new Parameter[]{session, cursor});
        method.comment("Filter: %s", new Object[]{filter});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        BytecodeExpressionVisitor visitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.metadata.getFunctionRegistry(), preGeneratedExpressions);
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate filter: " + filter).append(filter.accept(visitor, scope)).comment("if (wasNull) return false;").getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, String methodName, RowExpression projection) {
        PreGeneratedExpressions preGeneratedExpressions = this.generateMethodsForLambdaAndTry(classDefinition, callSiteBinder, cachedInstanceBinder, projection, methodName);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter output = Parameter.arg((String)"output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type(Void.TYPE), new Parameter[]{session, cursor, output});
        method.comment("Projection: %s", new Object[]{projection.toString()});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        BytecodeExpressionVisitor visitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.metadata.getFunctionRegistry(), preGeneratedExpressions);
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).getVariable((Variable)output).comment("evaluate projection: " + projection.toString()).append(projection.accept(visitor, scope)).append(BytecodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
    }

    private static RowExpressionVisitor<Scope, BytecodeNode> fieldReferenceCompiler(final Variable cursorVariable) {
        return new RowExpressionVisitor<Scope, BytecodeNode>(){

            @Override
            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Variable wasNullVariable = scope.getVariable("wasNull");
                Class<Object> javaType = type.getJavaType();
                if (!javaType.isPrimitive() && javaType != Slice.class) {
                    javaType = Object.class;
                }
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("cursor.get%s(%d)", type, field)).getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                ifStatement.ifFalse().getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "get" + Primitives.wrap(javaType).getSimpleName(), javaType, new Class[]{Integer.TYPE});
                return ifStatement;
            }

            @Override
            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

