/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class BufferingSplitSource
implements SplitSource {
    private final int bufferSize;
    private final SplitSource source;

    public BufferingSplitSource(SplitSource source, int bufferSize) {
        this.source = Objects.requireNonNull(source, "source is null");
        this.bufferSize = bufferSize;
    }

    @Override
    public ConnectorId getConnectorId() {
        return this.source.getConnectorId();
    }

    @Override
    public CompletableFuture<List<Split>> getNextBatch(int maxSize) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"Cannot fetch a batch of zero size");
        List<Split> result = Collections.synchronizedList(new ArrayList(maxSize));
        CompletableFuture<?> future = this.fetchSplits(Math.min(this.bufferSize, maxSize), maxSize, result);
        return future.thenApply(ignored -> ImmutableList.copyOf((Collection)result));
    }

    private CompletableFuture<?> fetchSplits(int min, int max, List<Split> output) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"Min splits greater than max splits");
        if (this.source.isFinished() || output.size() >= min) {
            return CompletableFuture.completedFuture(null);
        }
        return this.source.getNextBatch(max - output.size()).thenCompose(splits -> {
            output.addAll((Collection<Split>)splits);
            return this.fetchSplits(min, max, output);
        });
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }
}

