/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.RankingWindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;
import com.facebook.presto.spi.type.DoubleType;

@WindowFunctionSignature(name="percent_rank", returnType="double")
public class PercentRankFunction
extends RankingWindowFunction {
    private long totalCount;
    private long rank;
    private long count;

    public void reset() {
        this.totalCount = this.windowIndex.size();
        this.rank = 0L;
        this.count = 1L;
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (this.totalCount == 1L) {
            DoubleType.DOUBLE.writeDouble(output, 0.0);
            return;
        }
        if (newPeerGroup) {
            this.rank += this.count;
            this.count = 1L;
        } else {
            ++this.count;
        }
        DoubleType.DOUBLE.writeDouble(output, (double)(this.rank - 1L) / (double)(this.totalCount - 1L));
    }
}

