/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.type.LiteralParameter;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;

public final class CharacterStringCasts {
    private CharacterStringCasts() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToVarcharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        if (x > y) {
            return Varchars.truncateToLength((Slice)slice, (int)y.intValue());
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice charToCharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="char(x)") Slice slice) {
        if (x > y) {
            return Varchars.truncateToLength((Slice)slice, (int)y.intValue());
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToCharCast(@LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        return Chars.trimSpacesAndTruncateToLength((Slice)slice, (int)y.intValue());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice charToVarcharCast(@LiteralParameter(value="x") Long x, @LiteralParameter(value="y") Long y, @SqlType(value="char(x)") Slice slice) {
        if (x.intValue() <= y.intValue()) {
            return Chars.padSpaces((Slice)slice, (int)x.intValue());
        }
        return Chars.padSpaces((Slice)Varchars.truncateToLength((Slice)slice, (int)y.intValue()), (int)y.intValue());
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="char(y)")
    @LiteralParameters(value={"x", "y"})
    public static Slice varcharToCharSaturatedFloorCast(@LiteralParameter(value="y") Long y, @SqlType(value="varchar(x)") Slice slice) {
        int numberOfTrailingSpaces;
        Slice trimmedSlice = Chars.trimSpaces((Slice)slice);
        int trimmedTextLength = SliceUtf8.countCodePoints((Slice)trimmedSlice);
        if ((long)(trimmedTextLength + (numberOfTrailingSpaces = slice.length() - trimmedSlice.length())) >= y) {
            return Varchars.truncateToLength((Slice)trimmedSlice, (int)y.intValue());
        }
        if (trimmedTextLength == 0) {
            return Slices.EMPTY_SLICE;
        }
        return trimmedSlice.slice(0, SliceUtf8.offsetOfCodePoint((Slice)trimmedSlice, (int)(trimmedTextLength - 1)));
    }
}

