/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.exchange.PageReference;
import com.facebook.presto.spi.Page;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

class RandomExchanger
implements Consumer<Page> {
    private final List<Consumer<PageReference>> buffers;
    private final LongConsumer memoryTracker;

    public RandomExchanger(List<Consumer<PageReference>> buffers, LongConsumer memoryTracker) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(buffers, "buffers is null"));
        this.memoryTracker = Objects.requireNonNull(memoryTracker, "memoryTracker is null");
    }

    @Override
    public void accept(Page page) {
        this.memoryTracker.accept(page.getRetainedSizeInBytes());
        PageReference pageReference = new PageReference(page, 1, () -> this.memoryTracker.accept(-page.getRetainedSizeInBytes()));
        int randomIndex = ThreadLocalRandom.current().nextInt(this.buffers.size());
        this.buffers.get(randomIndex).accept(pageReference);
    }
}

